/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.decisions.hotreload;

import io.quarkus.test.QuarkusDevModeTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Objects;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class NewFileHotReloadIT {
    private static final String PACKAGE = "org.kie.kogito.quarkus.decisions.hotreload";
    private static final String RESOURCE_FILE_PATH;
    private static final String DMN_RESOURCE_FILE;
    @RegisterExtension
    static final QuarkusDevModeTest test;

    @Test
    void newFileTest() throws IOException {
        String httpPort = (String)ConfigProvider.getConfig().getValue("quarkus.http.port", String.class);
        ClassLoader classLoader = this.getClass().getClassLoader();
        File file = new File(Objects.requireNonNull(classLoader.getResource("TrafficViolation.txt")).getFile());
        String xml = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        test.addResourceFile(DMN_RESOURCE_FILE, xml);
        ValidatableResponse response = (ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + httpPort).contentType(ContentType.JSON).accept(ContentType.JSON).body("{\n    \"Driver\": {\n        \"Points\": 2\n    },\n    \"Violation\": {\n        \"Type\": \"speed\",\n        \"Actual Speed\": 120,\n        \"Speed Limit\": 100\n    }\n}").contentType(ContentType.JSON).when().post("/Traffic Violation", new Object[0])).then();
        ((ValidatableResponse)response.statusCode(200)).body("'Should the driver be suspended?'", Matchers.is((Object)"No"), new Object[0]);
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        RESOURCE_FILE_PATH = PACKAGE.replace('.', '/');
        DMN_RESOURCE_FILE = RESOURCE_FILE_PATH + "/TrafficViolation.dmn";
        test = new QuarkusDevModeTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsResource("adult.txt", DMN_RESOURCE_FILE + ".dummy"));
    }
}

