/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.it.kogito.jbpm;

import io.quarkus.it.kogito.jbpm.CalculationService;
import io.quarkus.it.kogito.jbpm.JbpmHotReloadTestHelper;
import io.quarkus.it.kogito.jbpm.Order;
import io.quarkus.test.QuarkusDevModeTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class HotReloadIT {
    private static final String PACKAGE = "io.quarkus.it.kogito.jbpm";
    private static final String PACKAGE_FOLDER;
    private static final String RESOURCE_FILE;
    private static final String HTTP_TEST_PORT = "65535";
    private static final String PROCESS_NAME = "text_process";
    @RegisterExtension
    static final QuarkusDevModeTest test;

    @Test
    public void testServletChange() {
        String payload = "{\"mytext\": \"HeLlO\"}";
        String id = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").contentType(ContentType.JSON).accept(ContentType.JSON).body(payload).when().post("/text_process", new Object[0])).then()).statusCode(201)).header("Location", Matchers.notNullValue())).body("id", Matchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        Map result = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").accept(ContentType.JSON).when().get("/text_process/{id}", new Object[]{id})).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((Object)"HELLO", result.get("mytext"));
        test.modifySourceFile(JbpmHotReloadTestHelper.class, s -> s.replace("toUpperCase", "toLowerCase"));
        id = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").contentType(ContentType.JSON).accept(ContentType.JSON).body(payload).when().post("/text_process", new Object[0])).then()).statusCode(201)).body("id", Matchers.notNullValue(), new Object[0])).header("Location", Matchers.notNullValue())).extract().path("id", new String[0]);
        result = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").accept(ContentType.JSON).when().get("/text_process/{id}", new Object[]{id})).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((Object)"hello", result.get("mytext"));
    }

    @Test
    public void testRenameProcess() {
        String payload = "{\"mytext\": \"HeLlO\"}";
        String id = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").contentType(ContentType.JSON).accept(ContentType.JSON).body(payload).when().post("/text_process", new Object[0])).then()).statusCode(201)).header("Location", Matchers.notNullValue())).body("id", Matchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        Map result = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").accept(ContentType.JSON).when().get("/text_process/{id}", new Object[]{id})).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((Object)"HELLO", result.get("mytext"));
        test.modifyResourceFile(RESOURCE_FILE, s -> s.replaceAll(PROCESS_NAME, "new_text_process"));
        id = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").contentType(ContentType.JSON).accept(ContentType.JSON).body(payload).when().post("/new_text_process", new Object[0])).then()).statusCode(201)).body("id", Matchers.notNullValue(), new Object[0])).header("Location", Matchers.notNullValue())).extract().path("id", new String[0]);
        result = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").accept(ContentType.JSON).when().get("/new_text_process/{id}", new Object[]{id})).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((Object)"HELLO", result.get("mytext"));
    }

    @Test
    public void testProcessJsonSchema() {
        String jsonSchema = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").contentType(ContentType.JSON).accept(ContentType.JSON).when().get("/text_process/schema", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertNotNull((Object)jsonSchema);
        Assertions.assertFalse((boolean)jsonSchema.isEmpty());
        test.modifyResourceFile(RESOURCE_FILE, s -> s.replaceAll(PROCESS_NAME, "new_text_process"));
        ((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").contentType(ContentType.JSON).accept(ContentType.JSON).when().get("/text_process/schema", new Object[0])).then()).statusCode(404);
        String newJsonSchema = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").contentType(ContentType.JSON).accept(ContentType.JSON).when().get("/new_text_process/schema", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertNotNull((Object)newJsonSchema);
        Assertions.assertFalse((boolean)newJsonSchema.isEmpty());
        Assertions.assertEquals((Object)jsonSchema, (Object)newJsonSchema);
    }

    @Test
    public void testUserTaskJsonSchema() {
        String jsonSchema = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").contentType(ContentType.JSON).accept(ContentType.JSON).when().get("/text_process/Task/schema", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertNotNull((Object)jsonSchema);
        Assertions.assertFalse((boolean)jsonSchema.isEmpty());
        test.modifyResourceFile(RESOURCE_FILE, s -> s.replaceAll("\\[Task]", "[Task1]"));
        ((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").contentType(ContentType.JSON).accept(ContentType.JSON).when().get("/text_process/Task/schema", new Object[0])).then()).statusCode(404);
        String newJsonSchema = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").contentType(ContentType.JSON).accept(ContentType.JSON).when().get("/text_process/Task1/schema", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertNotNull((Object)newJsonSchema);
        Assertions.assertFalse((boolean)newJsonSchema.isEmpty());
        Assertions.assertEquals((Object)jsonSchema, (Object)newJsonSchema);
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        PACKAGE_FOLDER = PACKAGE.replace('.', '/');
        RESOURCE_FILE = PACKAGE_FOLDER + "/text-process.bpmn";
        test = new QuarkusDevModeTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(CalculationService.class)).addClass(Order.class)).addAsResource("text-process.txt", RESOURCE_FILE)).addClass(JbpmHotReloadTestHelper.class));
    }
}

