/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.it.kogito.process;

import io.quarkus.it.kogito.process.CalculationService;
import io.quarkus.it.kogito.process.Order;
import io.quarkus.test.QuarkusDevModeTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.Duration;
import net.jcip.annotations.NotThreadSafe;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.kie.kogito.test.utils.SocketUtils;

@NotThreadSafe
public class KogitoDevServiceTest {
    private static final Duration TIMEOUT = Duration.ofMinutes(1L);
    private static final String DATA_INDEX_EPHEMERAL_IMAGE_TEST_PROPERTY = "data-index-ephemeral.image.test";
    private static final String DATA_INDEX_EPHEMERAL_IMAGE_TEST_DEFAULT_VALUE = "use-default-image";
    static final int httpPort;
    static final int dataIndexHttpPort;
    @RegisterExtension
    static final QuarkusDevModeTest test;

    @Test
    public void testDataIndexDevService() {
        Awaitility.await().atMost(TIMEOUT).ignoreExceptions().untilAsserted(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + dataIndexHttpPort).contentType(ContentType.JSON).accept(ContentType.JSON).body("{ \"query\" : \"{ ProcessInstances { id } }\"}").when().post("/graphql", new Object[0])).then()).statusCode(200)).body("data.ProcessInstances.size()", CoreMatchers.is((Object)0), new Object[0]));
        String addOrderPayload = "{\"approver\" : \"john\", \"order\" : {\"orderNumber\" : \"12345\", \"shipped\" : false}}";
        String processId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + httpPort).contentType(ContentType.JSON).accept(ContentType.JSON).body(addOrderPayload).when().post("/orders", new Object[0])).then()).statusCode(201)).header("Location", CoreMatchers.notNullValue())).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        Awaitility.await().atMost(TIMEOUT).untilAsserted(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + dataIndexHttpPort).contentType(ContentType.JSON).accept(ContentType.JSON).body("{ \"query\" : \"{ ProcessInstances (where: { id: {equal: \\\"" + processId + "\\\"}}) { id, processId, processName } }\"}").when().post("/graphql", new Object[0])).then()).statusCode(200)).body("data.ProcessInstances[0].id", CoreMatchers.is((Object)processId), new Object[0])).body("data.ProcessInstances[0].processId", CoreMatchers.is((Object)"demo.orders"), new Object[0])).body("data.ProcessInstances[0].processName", CoreMatchers.is((Object)"orders"), new Object[0]));
    }

    private static String getApplicationPropertiesContent() {
        return "quarkus.http.port=" + httpPort + "\nquarkus.kogito.devservices.port=" + dataIndexHttpPort + "\n" + KogitoDevServiceTest.getKogitoDevServicesImageName();
    }

    private static String getKogitoDevServicesImageName() {
        String imageName = System.getProperty(DATA_INDEX_EPHEMERAL_IMAGE_TEST_PROPERTY);
        if (imageName == null) {
            throw new IllegalStateException("Property data-index-ephemeral.image.test was not passed to tests!");
        }
        if (imageName.isEmpty() || DATA_INDEX_EPHEMERAL_IMAGE_TEST_DEFAULT_VALUE.equals(imageName)) {
            return "";
        }
        return "quarkus.kogito.devservices.image-name=" + imageName;
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        httpPort = SocketUtils.findAvailablePort();
        dataIndexHttpPort = SocketUtils.findAvailablePort();
        test = new QuarkusDevModeTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(CalculationService.class)).addClass(Order.class)).addAsResource((Asset)new StringAsset(KogitoDevServiceTest.getApplicationPropertiesContent()), "application.properties")).addAsResource("orderItems.bpmn")).addAsResource("orders.bpmn"));
    }
}

