/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import org.kie.kogito.Model;
import org.kie.kogito.incubation.application.AppRoot;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.Id;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.processes.LocalProcessId;
import org.kie.kogito.incubation.processes.ProcessIds;
import org.kie.kogito.incubation.processes.services.StraightThroughProcessService;
import org.kie.kogito.process.Process;

@Path(value="/hello")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class GreetingResource {
    @Inject
    AppRoot appRoot;
    @Inject
    StraightThroughProcessService svc;
    @Inject
    @Named(value="approvals")
    Process<? extends Model> approvalProcess;

    @POST
    public DataContext hello(Map<String, Object> payload) {
        System.out.println(payload);
        LocalProcessId id = ((ProcessIds)this.appRoot.get(ProcessIds.class)).get("scripts");
        return this.svc.evaluate((Id)id, (DataContext)MapDataContext.from(payload));
    }

    @GET
    @Path(value="/version")
    public Response version() {
        return Response.ok(Map.of("version", this.approvalProcess.version())).build();
    }
}

