/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import io.quarkus.test.junit.QuarkusTest;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.acme.travels.CompleteProcessListener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;

@QuarkusTest
public class TimersProcessTest {
    @Inject
    Application app;

    @Test
    public void testTimersProcess() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        ((DefaultProcessEventListenerConfig)this.app.config().process().processEventListeners()).register((ProcessEventListener)new CompleteProcessListener(latch));
        Process timersProcess = this.app.processes().processById("timers");
        Assertions.assertNotNull((Object)timersProcess);
        Model m = (Model)timersProcess.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("delay", "PT3S");
        m.fromMap(parameters);
        ProcessInstance processInstance = timersProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        latch.await(1L, TimeUnit.MINUTES);
        Optional exists = timersProcess.instances().findById(processInstance.id());
        Assertions.assertFalse((boolean)exists.isPresent());
    }
}

