/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import io.cloudevents.json.Json;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.kie.kogito.tracing.decision.aggregator.Aggregator;
import org.kie.kogito.tracing.decision.aggregator.DefaultAggregator;
import org.kie.kogito.tracing.decision.event.AfterEvaluateAllEvent;
import org.kie.kogito.tracing.decision.event.EvaluateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionTracingCollector {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionTracingCollector.class);
    private final Map<String, List<EvaluateEvent>> cacheMap;
    private final Aggregator<?> aggregator;
    private final Consumer<String> payloadConsumer;

    public DecisionTracingCollector(Consumer<String> payloadConsumer) {
        this(new DefaultAggregator(), payloadConsumer);
    }

    public DecisionTracingCollector(Aggregator<?> aggregator, Consumer<String> payloadConsumer) {
        this.payloadConsumer = payloadConsumer;
        this.cacheMap = new HashMap<String, List<EvaluateEvent>>();
        this.aggregator = aggregator;
    }

    public void addEvent(EvaluateEvent event) {
        LOG.trace("Received {}(evaluationId: {}, modelName: {}, modelNamespace: {})", new Object[]{event.getClass().getSimpleName(), event.getExecutionId(), event.getModelName(), event.getModelNamespace()});
        String evaluationId = event.getExecutionId();
        if (this.cacheMap.containsKey(evaluationId)) {
            this.cacheMap.get(evaluationId).add(event);
        } else {
            LinkedList<EvaluateEvent> list = new LinkedList<EvaluateEvent>();
            list.add(event);
            this.cacheMap.put(evaluationId, list);
            LOG.trace("Added evaluation {} to cache (current size: {})", (Object)evaluationId, (Object)this.cacheMap.size());
        }
        if (event instanceof AfterEvaluateAllEvent) {
            String payload = this.aggregate(evaluationId, this.cacheMap.get(evaluationId));
            this.payloadConsumer.accept(payload);
            LOG.debug("Generated aggregated event for evaluation {} (length {})", (Object)evaluationId, (Object)payload.length());
            this.cacheMap.remove(evaluationId);
            LOG.trace("Removed evaluation {} from cache (current size: {})", (Object)evaluationId, (Object)this.cacheMap.size());
        }
    }

    private String aggregate(String evaluationId, List<EvaluateEvent> events) {
        return Json.encode(this.aggregator.aggregate(evaluationId, events));
    }
}

