/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.event;

import java.util.List;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.kogito.tracing.decision.event.EvaluateEventMessage;
import org.kie.kogito.tracing.decision.event.EvaluateEventUtils;

public class EvaluateEventDecisionResult {
    private final String decisionId;
    private final String decisionName;
    private final DMNDecisionResult.DecisionEvaluationStatus evaluationStatus;
    private final Object result;
    private final List<EvaluateEventMessage> messages;
    private final boolean errors;

    public EvaluateEventDecisionResult(String decisionId, String decisionName, DMNDecisionResult.DecisionEvaluationStatus evaluationStatus, Object result, List<EvaluateEventMessage> messages, boolean errors) {
        this.decisionId = decisionId;
        this.decisionName = decisionName;
        this.evaluationStatus = evaluationStatus;
        this.result = result;
        this.messages = messages;
        this.errors = errors;
    }

    public String getDecisionId() {
        return this.decisionId;
    }

    public String getDecisionName() {
        return this.decisionName;
    }

    public DMNDecisionResult.DecisionEvaluationStatus getEvaluationStatus() {
        return this.evaluationStatus;
    }

    public Object getResult() {
        return this.result;
    }

    public List<EvaluateEventMessage> getMessages() {
        return this.messages;
    }

    public boolean hasErrors() {
        return this.errors;
    }

    public static EvaluateEventDecisionResult from(DMNDecisionResult dr) {
        return new EvaluateEventDecisionResult(dr.getDecisionId(), dr.getDecisionName(), dr.getEvaluationStatus(), dr.getResult(), EvaluateEventUtils.map(dr.getMessages(), EvaluateEventMessage::from), dr.hasErrors());
    }
}

