/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.event.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.kogito.tracing.decision.event.common.InternalMessageType;
import org.kie.kogito.tracing.decision.event.common.MessageCategory;
import org.kie.kogito.tracing.decision.event.common.MessageExceptionField;
import org.kie.kogito.tracing.decision.event.common.MessageFEELEvent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Message {
    private final Message.Level level;
    private final MessageCategory category;
    private final String type;
    private final String sourceId;
    private final String text;
    private final MessageFEELEvent feelEvent;
    private final MessageExceptionField exception;

    public Message(Message.Level level, MessageCategory category, String type, String sourceId, String text, MessageFEELEvent feelEvent, MessageExceptionField exception) {
        this.level = level;
        this.category = category;
        this.type = type;
        this.sourceId = sourceId;
        this.text = text;
        this.feelEvent = feelEvent;
        this.exception = exception;
    }

    public Message.Level getLevel() {
        return this.level;
    }

    public MessageCategory getCategory() {
        return this.category;
    }

    public String getType() {
        return this.type;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getText() {
        return this.text;
    }

    public MessageFEELEvent getFeelEvent() {
        return this.feelEvent;
    }

    public MessageExceptionField getException() {
        return this.exception;
    }

    public static Message from(DMNMessage message) {
        if (message == null) {
            return null;
        }
        return new Message(message.getLevel(), MessageCategory.DMN, message.getMessageType().name(), message.getSourceId(), message.getText(), MessageFEELEvent.from(message.getFeelEvent()), MessageExceptionField.from(message.getException()));
    }

    public static List<Message> from(List<DMNMessage> messages) {
        if (messages == null) {
            return null;
        }
        return messages.stream().map(Message::from).collect(Collectors.toList());
    }

    public static Message from(InternalMessageType message) {
        if (message == null) {
            return null;
        }
        return new Message(message.getLevel(), MessageCategory.INTERNAL, message.name(), null, message.getText(), null, null);
    }

    public static Message from(InternalMessageType message, Throwable throwable) {
        if (message == null) {
            return null;
        }
        return new Message(message.getLevel(), MessageCategory.INTERNAL, message.name(), null, message.getText(), null, MessageExceptionField.from(throwable));
    }
}

