/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.event.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.kogito.tracing.decision.event.common.MessageExceptionField;

public class MessageFEELEvent {
    private final FEELEvent.Severity severity;
    private final String message;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Integer line;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Integer column;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final MessageExceptionField sourceException;

    public MessageFEELEvent(FEELEvent.Severity severity, String message, Integer line, Integer column, MessageExceptionField sourceException) {
        this.severity = severity;
        this.message = message;
        this.line = line == null || line < 0 ? null : line;
        this.column = column == null || column < 0 ? null : column;
        this.sourceException = sourceException;
    }

    public FEELEvent.Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getLine() {
        return this.line;
    }

    public Integer getColumn() {
        return this.column;
    }

    public MessageExceptionField getSourceException() {
        return this.sourceException;
    }

    public static MessageFEELEvent from(FEELEvent feelEvent) {
        if (feelEvent == null) {
            return null;
        }
        return new MessageFEELEvent(feelEvent.getSeverity(), feelEvent.getMessage(), feelEvent.getLine(), feelEvent.getColumn(), MessageExceptionField.from(feelEvent.getSourceException()));
    }
}

