/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.event.trace;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.kie.dmn.api.core.DMNModel;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEvent;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEventType;

public class TraceResourceId {
    private final String modelNamespace;
    private final String modelName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String decisionServiceId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String decisionServiceName;

    public TraceResourceId(String modelNamespace, String modelName) {
        this(modelNamespace, modelName, null, null);
    }

    public TraceResourceId(String modelNamespace, String modelName, String decisionServiceId, String decisionServiceName) {
        this.modelNamespace = modelNamespace;
        this.modelName = modelName;
        this.decisionServiceId = decisionServiceId;
        this.decisionServiceName = decisionServiceName;
    }

    public String getModelNamespace() {
        return this.modelNamespace;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getDecisionServiceId() {
        return this.decisionServiceId;
    }

    public String getDecisionServiceName() {
        return this.decisionServiceName;
    }

    public static TraceResourceId from(DMNModel model) {
        if (model == null) {
            return null;
        }
        return new TraceResourceId(model.getNamespace(), model.getName());
    }

    public static TraceResourceId from(EvaluateEvent event) {
        if (event == null) {
            return null;
        }
        return event.getType() == EvaluateEventType.BEFORE_EVALUATE_DECISION_SERVICE || event.getType() == EvaluateEventType.AFTER_EVALUATE_DECISION_SERVICE ? new TraceResourceId(event.getModelNamespace(), event.getModelName(), event.getNodeId(), event.getNodeName()) : new TraceResourceId(event.getModelNamespace(), event.getModelName());
    }
}

