/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import com.fasterxml.jackson.core.type.TypeReference;
import io.cloudevents.json.Json;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.kogito.dmn.DMNKogito;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEvent;

public class DecisionTestUtils {
    public static final String MODEL_RESOURCE = "/Traffic Violation.dmn";
    public static final String MODEL_NAMESPACE = "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF";
    public static final String MODEL_NAME = "Traffic Violation";
    public static final String FIRST_DECISION_NODE_ID = "_4055D956-1C47-479C-B3F4-BAEB61F1C929";
    public static final String LAST_DECISION_NODE_ID = "_8A408366-D8E9-4626-ABF3-5F69AA01F880";
    public static final String DECISION_SERVICE_NODE_ID = "_073E3815-F30F-4835-A5CF-A9B354444E09";
    public static final String DECISION_SERVICE_NODE_NAME = "FineService";
    public static final String DECISION_SERVICE_DECISION_ID = "_4055D956-1C47-479C-B3F4-BAEB61F1C929";
    public static final String EVALUATE_ALL_EXECUTION_ID = "4ac4c69f-4925-4221-b67e-4b14ce47bef8";
    public static final String EVALUATE_ALL_JSON_RESOURCE = "/Traffic Violation_EvaluateEvents_evaluateAll.json";
    public static final String EVALUATE_DECISION_SERVICE_EXECUTION_ID = "77408667-f218-40b0-a355-1bab047a3e9e";
    public static final String EVALUATE_DECISION_SERVICE_JSON_RESOURCE = "/Traffic Violation_EvaluateEvents_evaluateDecisionService.json";
    private static final TypeReference<List<EvaluateEvent>> EVALUATE_EVENT_LIST_TYPE = new TypeReference<List<EvaluateEvent>>(){};

    public static DMNRuntime createDMNRuntime() {
        return DMNKogito.createGenericDMNRuntime((Reader[])new Reader[]{new InputStreamReader(DecisionTestUtils.class.getResourceAsStream(MODEL_RESOURCE))});
    }

    public static DMNModel createDMNModel() {
        return DecisionTestUtils.createDMNRuntime().getModel(MODEL_NAMESPACE, MODEL_NAME);
    }

    public static Map<String, Object> getEvaluateAllContext() {
        return Map.of("Driver", DecisionTestUtils.getDriver(25, 10), "Violation", DecisionTestUtils.getViolation("speed", 115, 100));
    }

    public static Map<String, Object> getEvaluateAllContextForWarning() {
        return Map.of("Driver", DecisionTestUtils.getDriver(25, 10), "Violation", DecisionTestUtils.getViolation("speed", 95, 100));
    }

    public static Map<String, Object> getEvaluateAllContextForError() {
        return Map.of("Violation", DecisionTestUtils.getViolation("speed", 115, 100));
    }

    public static Map<String, Object> getEvaluateDecisionServiceContext() {
        return Map.of("Violation", DecisionTestUtils.getViolation("speed", 115, 100));
    }

    public static Map<String, Object> getEvaluateDecisionServiceContextForWarning() {
        return Map.of("Violation", DecisionTestUtils.getViolation("speed", 95, 100));
    }

    public static Map<String, Object> getDriver(int age, int points) {
        return Map.of("Age", age, "Points", points);
    }

    public static Map<String, Object> getViolation(String type, int actualSpeed, int speedLimit) {
        return Map.of("Type", type, "Actual Speed", actualSpeed, "Speed Limit", speedLimit);
    }

    public static List<EvaluateEvent> readEvaluateEventsFromJsonResource(String resourceName) {
        return (List)Json.fromInputStream((InputStream)DecisionTestUtils.class.getResourceAsStream(resourceName), EVALUATE_EVENT_LIST_TYPE);
    }
}

