/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serialization.process.impl.marshallers;

import com.google.protobuf.Any;
import com.google.protobuf.Int32Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import org.kie.kogito.serialization.process.ObjectMarshallerStrategy;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerException;

public class ProtobufIntegerMarshallerStrategy
implements ObjectMarshallerStrategy {
    @Override
    public boolean acceptForMarshalling(Object value) {
        return Integer.class.equals(value.getClass());
    }

    @Override
    public boolean acceptForUnmarshalling(Object value) {
        return ((Any)value).is(Int32Value.class);
    }

    @Override
    public Object marshall(Object unmarshalled) {
        return Any.pack((Message)Int32Value.of((int)((Integer)unmarshalled)));
    }

    @Override
    public Object unmarshall(Object marshalled) {
        try {
            Any data = (Any)marshalled;
            Int32Value storedValue = (Int32Value)data.unpack(Int32Value.class);
            return storedValue.getValue();
        }
        catch (InvalidProtocolBufferException e1) {
            throw new ProcessInstanceMarshallerException("Error trying to unmarshalling a int value", e1);
        }
    }
}

