/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serialization.process;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.serialization.process.MarshallerContext;
import org.kie.kogito.serialization.process.MarshallerContextName;
import org.kie.kogito.serialization.process.MarshallerReaderContext;
import org.kie.kogito.serialization.process.MarshallerWriterContext;
import org.kie.kogito.serialization.process.ObjectMarshallerStrategy;
import org.kie.kogito.serialization.process.ProcessInstanceMarshaller;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerException;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerFactory;
import org.kie.kogito.serialization.process.impl.ProtobufProcessInstanceMarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceMarshallerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceMarshallerService.class);
    private List<ObjectMarshallerStrategy> strats = new ArrayList<ObjectMarshallerStrategy>();
    private Map<MarshallerContextName<Object>, Object> contextEntries = new HashMap<MarshallerContextName<Object>, Object>();
    private ProcessInstanceMarshallerFactory processInstanceMarshallerFactory;

    public static Builder newBuilder() {
        return new ProcessInstanceMarshallerService().new Builder();
    }

    private ProcessInstanceMarshallerService() {
    }

    protected void setupEnvironment(MarshallerContext env) {
        env.set(MarshallerContextName.OBJECT_MARSHALLING_STRATEGIES, this.strats.toArray(new ObjectMarshallerStrategy[this.strats.size()]));
        for (Map.Entry<MarshallerContextName<Object>, Object> entry : this.contextEntries.entrySet()) {
            env.set(entry.getKey(), entry.getValue());
        }
    }

    public byte[] marshallProcessInstance(ProcessInstance<?> processInstance) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MarshallerWriterContext context = this.processInstanceMarshallerFactory.newWriterContext(baos);
            this.setupEnvironment(context);
            ProcessInstanceMarshaller marshaller = this.processInstanceMarshallerFactory.newKogitoProcessInstanceMarshaller();
            marshaller.writeProcessInstance(context, processInstance);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ProcessInstanceMarshallerException("Error while marshalling process instance", e);
            }
        }
        baos.close();
        return byArray;
    }

    public ProcessInstance<?> unmarshallProcessInstance(byte[] data, Process<?> process, boolean readOnly) {
        ProcessInstance<?> processInstance;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            MarshallerReaderContext context = this.processInstanceMarshallerFactory.newReaderContext(bais);
            context.set(MarshallerContextName.MARSHALLER_PROCESS, process);
            context.set(MarshallerContextName.MARSHALLER_INSTANCE_READ_ONLY, readOnly);
            this.setupEnvironment(context);
            ProcessInstanceMarshaller marshaller = this.processInstanceMarshallerFactory.newKogitoProcessInstanceMarshaller();
            processInstance = marshaller.readProcessInstance(context);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ProcessInstanceMarshallerException("Error while unmarshalling process instance", e);
            }
        }
        bais.close();
        return processInstance;
    }

    public ProcessInstance<?> unmarshallProcessInstance(byte[] data, Process<?> process) {
        return this.unmarshallProcessInstance(data, process, false);
    }

    public ProcessInstance<?> unmarshallReadOnlyProcessInstance(byte[] data, Process<?> process) {
        return this.unmarshallProcessInstance(data, process, true);
    }

    public Consumer<AbstractProcessInstance<?>> createdReloadFunction(Supplier<byte[]> dataSupplier) {
        return processInstance -> {
            byte[] data = (byte[])dataSupplier.get();
            if (data == null) {
                LOGGER.warn("Process Instance {} cannot be found", (Object)processInstance.id());
            }
            try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
                MarshallerReaderContext context = this.processInstanceMarshallerFactory.newReaderContext(bais);
                context.set(MarshallerContextName.MARSHALLER_PROCESS, processInstance.process());
                this.setupEnvironment(context);
                ProcessInstanceMarshaller marshaller = this.processInstanceMarshallerFactory.newKogitoProcessInstanceMarshaller();
                marshaller.reloadProcessInstance(context, (ProcessInstance<?>)processInstance);
            }
            catch (Exception e) {
                LOGGER.warn("Process Instance {} cannot be reloaded", (Object)processInstance.id(), (Object)e);
            }
        };
    }

    public class Builder {
        public Builder() {
            ProcessInstanceMarshallerService.this.processInstanceMarshallerFactory = new ProtobufProcessInstanceMarshallerFactory();
        }

        public Builder withProcessInstanceMarshallerFactory(ProcessInstanceMarshallerFactory factory) {
            ProcessInstanceMarshallerService.this.processInstanceMarshallerFactory = factory;
            return this;
        }

        public <T> Builder withContextEntries(Map<MarshallerContextName<T>, T> contextEntries) {
            for (Map.Entry<MarshallerContextName<T>, T> item : contextEntries.entrySet()) {
                ProcessInstanceMarshallerService.this.contextEntries.put(item.getKey(), item.getValue());
            }
            return this;
        }

        public Builder withDefaultObjectMarshallerStrategies() {
            ServiceLoader<ObjectMarshallerStrategy> loader = ServiceLoader.load(ObjectMarshallerStrategy.class);
            for (ObjectMarshallerStrategy strategy : loader) {
                ProcessInstanceMarshallerService.this.strats.add(strategy);
            }
            return this;
        }

        public Builder withObjectMarshallerStrategies(ObjectMarshallerStrategy ... strategies) {
            for (ObjectMarshallerStrategy strategy : strategies) {
                ProcessInstanceMarshallerService.this.strats.add(strategy);
            }
            return this;
        }

        public ProcessInstanceMarshallerService build() {
            Collections.sort(ProcessInstanceMarshallerService.this.strats);
            return ProcessInstanceMarshallerService.this;
        }
    }
}

