/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serialization.process;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.jbpm.process.core.context.variable.Variable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;
import org.kie.kogito.serialization.process.MarshallerContextName;
import org.kie.kogito.serialization.process.MarshallerReaderContext;
import org.kie.kogito.serialization.process.MarshallerWriterContext;
import org.kie.kogito.serialization.process.ObjectMarshallerStrategy;
import org.kie.kogito.serialization.process.impl.ProtobufMarshallerReaderContext;
import org.kie.kogito.serialization.process.impl.ProtobufProcessMarshallerWriteContext;
import org.kie.kogito.serialization.process.impl.ProtobufVariableReader;
import org.kie.kogito.serialization.process.impl.ProtobufVariableWriter;

public class ProcessInstanceMarshallTest {
    private static Stream<Arguments> testRoundTrip() throws Exception {
        return Stream.of(Arguments.of((Object[])new Object[]{1}), Arguments.of((Object[])new Object[]{"hello"}), Arguments.of((Object[])new Object[]{Boolean.TRUE}), Arguments.of((Object[])new Object[]{Float.valueOf(2.0f)}), Arguments.of((Object[])new Object[]{3.0}), Arguments.of((Object[])new Object[]{5L}), Arguments.of((Object[])new Object[]{BigDecimal.valueOf(10L)}), Arguments.of((Object[])new Object[]{new MarshableObject("henry")}), Arguments.of((Object[])new Object[]{new ObjectMapper().readTree("{ \"key\" : \"value\" }")}), Arguments.of((Object[])new Object[]{new ObjectMapper().valueToTree((Object)new MarshableObject("henry"))}), Arguments.of((Object[])new Object[]{new Date()}), Arguments.of((Object[])new Object[]{Instant.now()}), Arguments.of((Object[])new Object[]{OffsetDateTime.now()}), Arguments.of((Object[])new Object[]{LocalDateTime.now()}), Arguments.of((Object[])new Object[]{LocalDate.now()}), Arguments.of((Object[])new Object[]{ZonedDateTime.now()}), Arguments.of((Object[])new Object[]{new Timestamp(System.currentTimeMillis())}), Arguments.of((Object[])new Object[]{Duration.ofDays(1L)}));
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    public void testRoundTrip(Object toMarshall) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ProtobufProcessMarshallerWriteContext ctxOut = new ProtobufProcessMarshallerWriteContext((OutputStream)out);
        ctxOut.set(MarshallerContextName.OBJECT_MARSHALLING_STRATEGIES, (Object)this.defaultStrategies());
        ProtobufVariableWriter writer = new ProtobufVariableWriter((MarshallerWriterContext)ctxOut);
        List variables = writer.buildVariables(Collections.singletonMap("var", toMarshall).entrySet().stream().collect(Collectors.toList()));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ProtobufMarshallerReaderContext ctxIn = new ProtobufMarshallerReaderContext((InputStream)in);
        ctxIn.set(MarshallerContextName.OBJECT_MARSHALLING_STRATEGIES, (Object)this.defaultStrategies());
        ProtobufVariableReader reader = new ProtobufVariableReader((MarshallerReaderContext)ctxIn);
        List unmarshalledVars = reader.buildVariables(variables);
        Assertions.assertThat((List)unmarshalledVars).hasSize(1);
        Assertions.assertThat((Object)((Variable)unmarshalledVars.get(0)).getValue()).isEqualTo(toMarshall);
    }

    private ObjectMarshallerStrategy[] defaultStrategies() {
        ArrayList<ObjectMarshallerStrategy> strats = new ArrayList<ObjectMarshallerStrategy>();
        ServiceLoader<ObjectMarshallerStrategy> loader = ServiceLoader.load(ObjectMarshallerStrategy.class);
        for (ObjectMarshallerStrategy strategy : loader) {
            strats.add(strategy);
        }
        Collections.sort(strats);
        return (ObjectMarshallerStrategy[])strats.stream().toArray(ObjectMarshallerStrategy[]::new);
    }

    public static class MarshableObject
    implements Serializable {
        private static final long serialVersionUID = 1481370154514125687L;
        private String name;

        public MarshableObject() {
        }

        public MarshableObject(String name) {
            this.name = name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MarshableObject) {
                return this.name.equals(((MarshableObject)obj).name);
            }
            return false;
        }
    }
}

