/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serialization.process.impl;

import com.google.protobuf.Any;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import org.kie.kogito.serialization.process.MarshallerContext;
import org.kie.kogito.serialization.process.MarshallerContextName;
import org.kie.kogito.serialization.process.ObjectMarshallerStrategy;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerException;

public abstract class ProtobufAbstractMarshallerContext
implements MarshallerContext {
    private Map<MarshallerContextName, Object> env = new HashMap<MarshallerContextName, Object>();

    @Override
    public <T> T get(MarshallerContextName<T> key) {
        return (T)this.env.get(key);
    }

    @Override
    public <T> void set(MarshallerContextName<T> key, T value) {
        this.env.put(key, value);
    }

    @Override
    public ObjectMarshallerStrategy findObjectMarshallerStrategyFor(Object value) {
        return this.findMarshaller(value, (s, v) -> s.acceptForMarshalling(v));
    }

    @Override
    public ObjectMarshallerStrategy findObjectUnmarshallerStrategyFor(Any value) {
        return this.findMarshaller(value, (s, v) -> s.acceptForUnmarshalling((Any)v));
    }

    private ObjectMarshallerStrategy findMarshaller(Object value, BiPredicate<ObjectMarshallerStrategy, Object> type) {
        ObjectMarshallerStrategy[] objectMarshallerStrategies;
        for (ObjectMarshallerStrategy current : objectMarshallerStrategies = this.get(MarshallerContextName.OBJECT_MARSHALLING_STRATEGIES)) {
            if (!type.test(current, value)) continue;
            return current;
        }
        throw new ProcessInstanceMarshallerException("No marshaller found for class " + value.getClass().getName());
    }
}

