/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.hamcrest.CoreMatchers;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.AccessTokenResponse;
import org.kie.kogito.testcontainers.quarkus.KeycloakQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=KeycloakQuarkusTestResource.class)
public class ApprovalsRestIT {
    @ConfigProperty(name="quarkus.oidc.auth-server-url")
    private String keycloakUrl;

    @Test
    public void testStartApprovalUnauthorized() {
        ((ValidatableResponse)((Response)RestAssured.given().body("{\"traveller\" : {\"firstName\" : \"John\",\"lastName\" : \"Doe\",\"email\" : \"john.doe@example.com\",\"nationality\" : \"American\",\"address\" : {\"street\" : \"main street\",\"city\" : \"Boston\",\"zipCode\" : \"10005\",\"country\" : \"US\"}}}").contentType(ContentType.JSON).when().post("/approvals", new Object[0])).then()).statusCode(401);
    }

    @Test
    public void testStartApprovalAuthorized() {
        String id = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("mary")).body("{\"traveller\" : {\"firstName\" : \"John\",\"lastName\" : \"Doe\",\"email\" : \"john.doe@example.com\",\"nationality\" : \"American\",\"address\" : {\"street\" : \"main street\",\"city\" : \"Boston\",\"zipCode\" : \"10005\",\"country\" : \"US\"}}}").contentType(ContentType.JSON).when().post("/approvals", new Object[0])).then()).statusCode(201)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("mary")).accept(ContentType.JSON).when().get("/approvals", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)id)});
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("mary")).accept(ContentType.JSON).when().get("/approvals/" + id, new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)id), new Object[0]);
        String taskInfo = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("mary")).accept(ContentType.JSON).when().get("/approvals/" + id + "/tasks?user=admin&group=managers", new Object[0])).then()).statusCode(200)).body("$.size", CoreMatchers.is((Object)1), new Object[0])).body("[0].name", CoreMatchers.is((Object)"firstLineApproval"), new Object[0])).extract().path("[0].id", new String[0]);
        String payload = "{}";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("mary")).contentType(ContentType.JSON).accept(ContentType.JSON).body(payload).when().post("/approvals/" + id + "/firstLineApproval/" + taskInfo + "?user=mary&group=managers", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)id), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("mary")).accept(ContentType.JSON).when().delete("/approvals/" + id, new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)id), new Object[0]);
    }

    private String getAccessToken(String userName) {
        return ((AccessTokenResponse)((Response)RestAssured.given().param("grant_type", new Object[]{"password"}).param("username", new Object[]{userName}).param("password", new Object[]{userName}).param("client_id", new Object[]{"kogito-app"}).param("client_secret", new Object[]{"secret"}).when().post(this.keycloakUrl + "/protocol/openid-connect/token", new Object[0])).as(AccessTokenResponse.class)).getToken();
    }
}

