/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import org.acme.travels.KeycloakContainerResource;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.keycloak.representations.AccessTokenResponse;
import org.kie.kogito.springboot.KogitoSpringbootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class ApprovalsRestIT {
    @ClassRule
    public static final KeycloakContainerResource keycloak = new KeycloakContainerResource();
    @LocalServerPort
    int randomServerPort;

    @Before
    public void before() {
        RestAssured.port = this.randomServerPort;
    }

    @Test
    public void testStartApprovalUnauthorized() {
        ((ValidatableResponse)((Response)RestAssured.given().body("{\"traveller\" : {\"firstName\" : \"John\",\"lastName\" : \"Doe\",\"email\" : \"john.doe@example.com\",\"nationality\" : \"American\",\"address\" : {\"street\" : \"main street\",\"city\" : \"Boston\",\"zipCode\" : \"10005\",\"country\" : \"US\"}}").contentType(ContentType.JSON).when().post("/approvals", new Object[0])).then()).statusCode(401);
    }

    @Test
    public void testStartApprovalAuthorized() {
        String id = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("mary")).body("{\"traveller\" : {\"firstName\" : \"John\",\"lastName\" : \"Doe\",\"email\" : \"john.doe@example.com\",\"nationality\" : \"American\",\"address\" : {\"street\" : \"main street\",\"city\" : \"Boston\",\"zipCode\" : \"10005\",\"country\" : \"US\"}}}").contentType(ContentType.JSON).when().post("/approvals", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("mary")).accept(ContentType.JSON).when().get("/approvals", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)id)});
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("mary")).accept(ContentType.JSON).when().get("/approvals/" + id, new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)id), new Object[0]);
        Map taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("mary")).accept(ContentType.JSON).when().get("/approvals/" + id + "/tasks?user=admin&group=managers", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assert.assertEquals((long)1L, (long)taskInfo.size());
        taskInfo.containsValue("firstLineApproval");
        String payload = "{}";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("mary")).contentType(ContentType.JSON).accept(ContentType.JSON).body(payload).when().post("/approvals/" + id + "/firstLineApproval/" + taskInfo.keySet().iterator().next() + "?user=mary&group=managers", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)id), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("mary")).accept(ContentType.JSON).when().delete("/approvals/" + id, new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)id), new Object[0]);
    }

    private String getAccessToken(String userName) {
        return ((AccessTokenResponse)((Response)RestAssured.given().param("grant_type", new Object[]{"password"}).param("username", new Object[]{userName}).param("password", new Object[]{userName}).param("client_id", new Object[]{"kogito-app"}).param("client_secret", new Object[]{"secret"}).when().post("http://localhost:8281/auth/realms/kogito/protocol/openid-connect/token", new Object[0])).as(AccessTokenResponse.class)).getToken();
    }
}

