/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import java.util.function.Consumer;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class KeycloakContainerResource
extends ExternalResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakContainerResource.class);
    private static final String KEYCLOAK_IMAGE = System.getProperty("container.image.keycloak");
    private GenericContainer keycloak;

    protected void before() {
        this.keycloak = new FixedHostPortGenericContainer(KEYCLOAK_IMAGE).withFixedExposedPort(8281, 8080).withEnv("KEYCLOAK_USER", "admin").withEnv("KEYCLOAK_PASSWORD", "admin").withEnv("KEYCLOAK_IMPORT", "/tmp/realm.json").withClasspathResourceMapping("kogito-realm.json", "/tmp/realm.json", BindMode.READ_ONLY).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).waitingFor((WaitStrategy)Wait.forHttp((String)"/auth"));
        this.keycloak.start();
    }

    protected void after() {
        this.keycloak.stop();
    }
}

