/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.task.notification.quarkus;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class NotificationEventPublisher
implements EventPublisher {
    private static final Logger logger = LoggerFactory.getLogger((String)NotificationEventPublisher.class.getName());
    private static final String CHANNEL_NAME = "kogito-deadline-events";
    @Inject
    @Channel(value="kogito-deadline-events")
    Emitter<DataEvent<?>> emitter;

    public void publish(DataEvent<?> event) {
        if (event.getType().startsWith("UserTaskDeadline")) {
            logger.debug("About to publish event {} to topic {}", event, (Object)CHANNEL_NAME);
            try {
                this.emitter.send(event);
                logger.debug("Successfully published event {} to topic {}", event, (Object)CHANNEL_NAME);
            }
            catch (Exception e) {
                logger.error("Error while publishing event to topic {} for event {}", new Object[]{CHANNEL_NAME, event, e});
            }
        } else {
            logger.debug("Unknown type of event '{}', ignoring", (Object)event.getType());
        }
    }

    public void publish(Collection<DataEvent<?>> events) {
        for (DataEvent<?> event : events) {
            this.publish(event);
        }
    }
}

