/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.event.evaluate;

import java.util.List;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.kogito.tracing.decision.event.EventUtils;
import org.kie.kogito.tracing.decision.event.common.Message;

public class EvaluateDecisionResult {
    private String decisionId;
    private String decisionName;
    private DMNDecisionResult.DecisionEvaluationStatus evaluationStatus;
    private Object result;
    private List<Message> messages;
    private boolean errors;

    public EvaluateDecisionResult(String decisionId, String decisionName, DMNDecisionResult.DecisionEvaluationStatus evaluationStatus, Object result, List<Message> messages, boolean errors) {
        this.decisionId = decisionId;
        this.decisionName = decisionName;
        this.evaluationStatus = evaluationStatus;
        this.result = result;
        this.messages = messages;
        this.errors = errors;
    }

    private EvaluateDecisionResult() {
    }

    public String getDecisionId() {
        return this.decisionId;
    }

    public String getDecisionName() {
        return this.decisionName;
    }

    public DMNDecisionResult.DecisionEvaluationStatus getEvaluationStatus() {
        return this.evaluationStatus;
    }

    public Object getResult() {
        return this.result;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public boolean hasErrors() {
        return this.errors;
    }

    public static EvaluateDecisionResult from(DMNDecisionResult dr) {
        return new EvaluateDecisionResult(dr.getDecisionId(), dr.getDecisionName(), dr.getEvaluationStatus(), dr.getResult(), EventUtils.map(dr.getMessages(), EventUtils::messageFrom), dr.hasErrors());
    }
}

