/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import io.cloudevents.CloudEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.kie.dmn.api.core.DMNModel;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.tracing.decision.aggregator.Aggregator;
import org.kie.kogito.tracing.decision.aggregator.DefaultAggregator;
import org.kie.kogito.tracing.decision.event.CloudEventUtils;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEvent;
import org.kie.kogito.tracing.decision.terminationdetector.CounterTerminationDetector;
import org.kie.kogito.tracing.decision.terminationdetector.TerminationDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionTracingCollector {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionTracingCollector.class);
    private final Map<String, List<EvaluateEvent>> cacheMap = new HashMap<String, List<EvaluateEvent>>();
    private final Map<String, TerminationDetector> terminationDetectorMap = new HashMap<String, TerminationDetector>();
    private final Aggregator aggregator;
    private final Consumer<String> payloadConsumer;
    private final BiFunction<String, String, DMNModel> modelSupplier;
    private final Supplier<TerminationDetector> terminationDetectorSupplier;
    private final ConfigBean configBean;

    public DecisionTracingCollector(Consumer<String> payloadConsumer, BiFunction<String, String, DMNModel> modelSupplier, ConfigBean configBean) {
        this(new DefaultAggregator(), payloadConsumer, modelSupplier, CounterTerminationDetector::new, configBean);
    }

    public DecisionTracingCollector(Aggregator aggregator, Consumer<String> payloadConsumer, BiFunction<String, String, DMNModel> modelSupplier, Supplier<TerminationDetector> terminationDetectorSupplier, ConfigBean configBean) {
        this.aggregator = aggregator;
        this.payloadConsumer = payloadConsumer;
        this.modelSupplier = modelSupplier;
        this.terminationDetectorSupplier = terminationDetectorSupplier;
        this.configBean = configBean;
    }

    public void addEvent(EvaluateEvent event) {
        LOG.trace("Received {}(executionId: {}, modelName: {}, modelNamespace: {})", new Object[]{event.getType(), event.getExecutionId(), event.getModelName(), event.getModelNamespace()});
        String executionId = event.getExecutionId();
        if (!this.cacheMap.containsKey(executionId)) {
            this.cacheMap.put(executionId, new LinkedList());
            this.terminationDetectorMap.put(executionId, this.terminationDetectorSupplier.get());
            LOG.trace("Added evaluation {} to cache (current size: {})", (Object)executionId, (Object)this.cacheMap.size());
        }
        this.cacheMap.get(executionId).add(event);
        this.terminationDetectorMap.get(executionId).add(event);
        if (this.terminationDetectorMap.get(executionId).isTerminated()) {
            DMNModel dmnModel = this.modelSupplier.apply(event.getModelNamespace(), event.getModelName());
            String payload = this.aggregate(dmnModel, executionId, this.cacheMap.get(executionId));
            this.payloadConsumer.accept(payload);
            LOG.debug("Generated aggregated event for evaluation {} (length {})", (Object)executionId, (Object)payload.length());
            this.cacheMap.remove(executionId);
            this.terminationDetectorMap.remove(executionId);
            LOG.trace("Removed evaluation {} from cache (current size: {})", (Object)executionId, (Object)this.cacheMap.size());
        }
    }

    private String aggregate(DMNModel model, String executionId, List<EvaluateEvent> events) {
        return CloudEventUtils.encode((CloudEvent)this.aggregator.aggregate(model, executionId, events, this.configBean));
    }
}

