/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.dmn.DmnDecisionModel;
import org.kie.kogito.tracing.decision.DecisionTestUtils;
import org.kie.kogito.tracing.decision.DecisionTracingListener;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Disabled
class EvaluateEventJsonGeneratorTest {
    static final ObjectMapper MAPPER = new ObjectMapper().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, false).registerModule((Module)new JavaTimeModule()).setDefaultPrettyPrinter((PrettyPrinter)new TestPrettyPrinter());

    EvaluateEventJsonGeneratorTest() {
    }

    @Test
    void generateEvaluateAll() throws JsonProcessingException {
        this.generate("4ac4c69f-4925-4221-b67e-4b14ce47bef8", DecisionTestUtils.getEvaluateAllContext(), DecisionModel::evaluateAll, 14);
    }

    @Test
    void generateEvaluateDecisionService() throws JsonProcessingException {
        this.generate("77408667-f218-40b0-a355-1bab047a3e9e", DecisionTestUtils.getEvaluateDecisionServiceContext(), (model, context) -> model.evaluateDecisionService(context, "FineService"), 6);
    }

    private void generate(String executionId, Map<String, Object> contextVariables, BiConsumer<DecisionModel, DMNContext> modelConsumer, int expectedEvents) throws JsonProcessingException {
        DMNRuntime runtime = DecisionTestUtils.createDMNRuntime();
        Consumer eventConsumer = (Consumer)Mockito.mock(Consumer.class);
        DecisionTracingListener listener = new DecisionTracingListener(eventConsumer);
        runtime.addListener((DMNRuntimeEventListener)listener);
        DmnDecisionModel model = new DmnDecisionModel(runtime, "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation", () -> executionId);
        DMNContext context = model.newContext(contextVariables);
        modelConsumer.accept((DecisionModel)model, context);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(EvaluateEvent.class);
        ((Consumer)Mockito.verify((Object)eventConsumer, (VerificationMode)Mockito.times((int)expectedEvents))).accept((EvaluateEvent)eventCaptor.capture());
        System.out.println(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)eventCaptor.getAllValues()));
    }

    static class TestPrettyPrinter
    extends DefaultPrettyPrinter {
        public TestPrettyPrinter() {
            this._arrayIndenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE;
            this._objectFieldValueSeparatorWithSpaces = ": ";
        }

        public DefaultPrettyPrinter createInstance() {
            return new TestPrettyPrinter();
        }

        public void writeEndObject(JsonGenerator g, int nrOfEntries) throws IOException {
            if (!this._objectIndenter.isInline()) {
                --this._nesting;
            }
            if (nrOfEntries > 0) {
                this._objectIndenter.writeIndentation(g, this._nesting);
            }
            g.writeRaw('}');
        }

        public void writeEndArray(JsonGenerator g, int nrOfValues) throws IOException {
            if (!this._arrayIndenter.isInline()) {
                --this._nesting;
            }
            if (nrOfValues > 0) {
                this._arrayIndenter.writeIndentation(g, this._nesting);
            }
            g.writeRaw(']');
        }
    }
}

