/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.aggregator;

import com.fasterxml.jackson.databind.JsonNode;
import io.cloudevents.CloudEvent;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.DecisionServiceNodeImpl;
import org.kie.dmn.feel.util.Pair;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.tracing.decision.aggregator.Aggregator;
import org.kie.kogito.tracing.decision.aggregator.DefaultAggregatorStackEntry;
import org.kie.kogito.tracing.decision.event.CloudEventUtils;
import org.kie.kogito.tracing.decision.event.EventUtils;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateDecisionResult;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEvent;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEventType;
import org.kie.kogito.tracing.decision.event.message.InternalMessageType;
import org.kie.kogito.tracing.decision.event.message.Message;
import org.kie.kogito.tracing.decision.event.trace.TraceEvent;
import org.kie.kogito.tracing.decision.event.trace.TraceEventType;
import org.kie.kogito.tracing.decision.event.trace.TraceExecutionStep;
import org.kie.kogito.tracing.decision.event.trace.TraceExecutionStepType;
import org.kie.kogito.tracing.decision.event.trace.TraceHeader;
import org.kie.kogito.tracing.decision.event.trace.TraceInputValue;
import org.kie.kogito.tracing.decision.event.trace.TraceOutputValue;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAggregator
implements Aggregator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAggregator.class);
    private static final String UNKNOWN_SOURCE_URI_STRING = (String)CloudEventUtils.urlEncodedStringFrom((String)"__UNKNOWN_SOURCE__").orElseThrow(IllegalStateException::new);
    private static final String EXPRESSION_ID_KEY = "expressionId";
    private static final String MATCHES_KEY = "matches";
    private static final String NODE_ID_KEY = "nodeId";
    private static final String NODE_NAME_KEY = "nodeName";
    private static final String SELECTED_KEY = "selected";
    private static final String VARIABLE_ID_KEY = "variableId";

    @Override
    public Optional<CloudEvent> aggregate(DMNModel model, String executionId, List<EvaluateEvent> events, ConfigBean configBean) {
        return events == null || events.isEmpty() ? DefaultAggregator.buildNotEnoughDataCloudEvent(model, executionId, configBean) : DefaultAggregator.buildDefaultCloudEvent(model, executionId, events, configBean);
    }

    private static Optional<CloudEvent> buildNotEnoughDataCloudEvent(DMNModel model, String executionId, ConfigBean configBean) {
        TraceHeader header = new TraceHeader(TraceEventType.DMN, executionId, null, null, null, EventUtils.traceResourceIdFrom(configBean.getServiceUrl(), model), Stream.of(EventUtils.messageFrom(InternalMessageType.NOT_ENOUGH_DATA), model == null ? EventUtils.messageFrom(InternalMessageType.DMN_MODEL_NOT_FOUND) : null).filter(Objects::nonNull).collect(Collectors.toList()));
        TraceEvent event = new TraceEvent(header, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        return CloudEventUtils.build((String)executionId, (URI)DefaultAggregator.buildSource(configBean.getServiceUrl(), null), (Object)event, TraceEvent.class);
    }

    private static Optional<CloudEvent> buildDefaultCloudEvent(DMNModel model, String executionId, List<EvaluateEvent> events, ConfigBean configBean) {
        EvaluateEvent firstEvent = events.get(0);
        EvaluateEvent lastEvent = events.get(events.size() - 1);
        List<TraceInputValue> inputs = DefaultAggregator.buildTraceInputValues(model, firstEvent);
        List<TraceOutputValue> outputs = DefaultAggregator.buildTraceOutputValues(model, lastEvent);
        Pair<List<TraceExecutionStep>, List<Message>> executionStepsPair = DefaultAggregator.buildTraceExecutionSteps(model, executionId, events);
        TraceHeader header = new TraceHeader(TraceEventType.DMN, executionId, Long.valueOf(firstEvent.getTimestamp()), Long.valueOf(lastEvent.getTimestamp()), Long.valueOf(DefaultAggregator.computeDurationMillis(firstEvent, lastEvent)), firstEvent.toTraceResourceId(configBean.getServiceUrl()), Stream.of(model == null ? Stream.of(EventUtils.messageFrom(InternalMessageType.DMN_MODEL_NOT_FOUND)) : Stream.empty(), ((List)executionStepsPair.getRight()).stream(), lastEvent.getResult().getMessages().stream().filter(m -> m.getSourceId() == null || m.getSourceId().isEmpty())).flatMap(Function.identity()).collect(Collectors.toList()));
        TraceEvent event = new TraceEvent(header, inputs, outputs, (List)executionStepsPair.getLeft());
        return CloudEventUtils.build((String)executionId, (URI)DefaultAggregator.buildSource(configBean.getServiceUrl(), firstEvent), (Object)event, TraceEvent.class);
    }

    private static URI buildSource(String serviceUrl, EvaluateEvent event) {
        String modelChunk = Optional.ofNullable(event).map(EvaluateEvent::getModelName).flatMap(CloudEventUtils::urlEncodedStringFrom).orElse(null);
        String decisionChunk = Optional.ofNullable(event).filter(e -> e.getType() == EvaluateEventType.BEFORE_EVALUATE_DECISION_SERVICE || e.getType() == EvaluateEventType.AFTER_EVALUATE_DECISION_SERVICE).map(EvaluateEvent::getNodeName).flatMap(CloudEventUtils::urlEncodedStringFrom).orElse(null);
        String fullUrl = Stream.of(serviceUrl, modelChunk, decisionChunk).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining("/"));
        return URI.create(Optional.of(fullUrl).filter(s -> !s.isEmpty()).orElse(UNKNOWN_SOURCE_URI_STRING));
    }

    private static List<TraceInputValue> buildTraceInputValues(DMNModel model, EvaluateEvent firstEvent) {
        Map<String, InputDataNode> inputNodesMap = DefaultAggregator.inputDataNodesFromFirstEvent(model, firstEvent).stream().collect(Collectors.toMap(DMNNode::getName, Function.identity()));
        return Stream.concat(DefaultAggregator.streamInputsFromInitialContext(firstEvent, inputNodesMap), DefaultAggregator.streamKnownInputsNotInInitialContext(firstEvent, inputNodesMap)).collect(Collectors.toList());
    }

    private static Collection<InputDataNode> inputDataNodesFromFirstEvent(DMNModel model, EvaluateEvent firstEvent) {
        if (model == null || firstEvent == null) {
            return Collections.emptyList();
        }
        if (firstEvent.getType() == EvaluateEventType.BEFORE_EVALUATE_DECISION_SERVICE) {
            Optional<DecisionServiceNodeImpl> optNode = model.getDecisionServices().stream().filter(ds -> ds.getId().equals(firstEvent.getNodeId())).findFirst().filter(DecisionServiceNodeImpl.class::isInstance).map(DecisionServiceNodeImpl.class::cast);
            if (optNode.isPresent()) {
                return optNode.get().getInputParameters().values().stream().filter(InputDataNode.class::isInstance).map(InputDataNode.class::cast).collect(Collectors.toList());
            }
        }
        return model.getInputs();
    }

    private static Stream<TraceInputValue> streamInputsFromInitialContext(EvaluateEvent firstEvent, Map<String, InputDataNode> inputNodesMap) {
        return firstEvent.getContext().entrySet().stream().map(entry -> DefaultAggregator.buildTraceInputValue((String)entry.getKey(), entry.getValue(), inputNodesMap));
    }

    private static TraceInputValue buildTraceInputValue(String name, Object value, Map<String, InputDataNode> inputNodesMap) {
        return inputNodesMap.containsKey(name) ? DefaultAggregator.traceInputFrom(inputNodesMap.get(name), value) : DefaultAggregator.traceInputFrom(name, value);
    }

    private static Stream<TraceInputValue> streamKnownInputsNotInInitialContext(EvaluateEvent firstEvent, Map<String, InputDataNode> inputNodesMap) {
        return inputNodesMap.entrySet().stream().filter(entry -> !firstEvent.getContext().containsKey(entry.getKey())).map(entry -> DefaultAggregator.traceInputFrom((InputDataNode)entry.getValue(), null));
    }

    private static List<TraceOutputValue> buildTraceOutputValues(DMNModel model, EvaluateEvent lastEvent) {
        return lastEvent.getResult().getDecisionResults().stream().map(dr -> DefaultAggregator.traceOutputFrom(dr, model, lastEvent.getContext())).collect(Collectors.toList());
    }

    private static Pair<List<TraceExecutionStep>, List<Message>> buildTraceExecutionSteps(DMNModel model, String executionId, List<EvaluateEvent> events) {
        try {
            return new Pair(DefaultAggregator.buildTraceExecutionStepsHierarchy(model, events), Collections.emptyList());
        }
        catch (IllegalStateException e) {
            LOG.error(String.format("IllegalStateException during aggregation of evaluation %s", executionId), (Throwable)e);
            return new Pair(DefaultAggregator.buildTraceExecutionStepsList(model, events), Arrays.asList(EventUtils.messageFrom(InternalMessageType.NO_EXECUTION_STEP_HIERARCHY, e)));
        }
    }

    private static List<TraceExecutionStep> buildTraceExecutionStepsHierarchy(DMNModel model, List<EvaluateEvent> events) {
        ArrayList<TraceExecutionStep> executionSteps = new ArrayList<TraceExecutionStep>(events.size() / 2);
        ArrayDeque<DefaultAggregatorStackEntry> stack = new ArrayDeque<DefaultAggregatorStackEntry>(events.size() / 2);
        for (int i = 1; i < events.size() - 1; ++i) {
            DefaultAggregator.processEvaluateEventInHierarchy(model, stack, executionSteps, events.get(i));
        }
        if (!stack.isEmpty()) {
            throw new IllegalStateException("Can't match all after events with corresponding before events");
        }
        return executionSteps;
    }

    private static void processEvaluateEventInHierarchy(DMNModel model, Deque<DefaultAggregatorStackEntry> stack, List<TraceExecutionStep> executionSteps, EvaluateEvent event) {
        LOG.trace("Started aggregating event {} (execution steps: {}, stack size: {})", new Object[]{event.getType(), executionSteps.size(), stack.size()});
        if (event.getType().isBefore()) {
            stack.push(new DefaultAggregatorStackEntry(event));
        } else {
            if (stack.isEmpty() || !stack.peek().isValidAfterEvent(event)) {
                throw new IllegalStateException(String.format("Can't match %s after event with corresponding before event", new Object[]{event.getType()}));
            }
            DefaultAggregatorStackEntry stackEntry = stack.pop();
            TraceExecutionStep step = DefaultAggregator.buildTraceExecutionStep(model, stackEntry, event);
            if (step == null) {
                throw new IllegalStateException(String.format("Can't build TraceExecutionStep for a %s event", new Object[]{event.getType()}));
            }
            if (stack.isEmpty()) {
                executionSteps.add(step);
            } else {
                stack.peek().addChild(step);
            }
        }
        LOG.trace("Finished aggregating event {} (execution steps: {}, stack size: {})", new Object[]{event.getType(), executionSteps.size(), stack.size()});
    }

    private static List<TraceExecutionStep> buildTraceExecutionStepsList(DMNModel model, List<EvaluateEvent> events) {
        return events.stream().filter(e -> e.getType().isAfter()).map(e -> DefaultAggregator.buildTraceExecutionStep(model, null, e)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static TraceExecutionStep buildTraceExecutionStep(DMNModel model, DefaultAggregatorStackEntry stackEntry, EvaluateEvent afterEvent) {
        TraceExecutionStepType type = Optional.ofNullable(afterEvent.getType()).map(EvaluateEventType::toTraceExecutionStepType).orElse(null);
        if (type == null) {
            return null;
        }
        long duration = Optional.ofNullable(stackEntry).map(DefaultAggregatorStackEntry::getBeforeEvent).map(beforeEvent -> DefaultAggregator.computeDurationMillis(beforeEvent, afterEvent)).orElse(0L);
        List<TraceExecutionStep> children = Optional.ofNullable(stackEntry).map(DefaultAggregatorStackEntry::getChildren).orElse(Collections.emptyList());
        switch (type) {
            case DMN_BKM_EVALUATION: 
            case DMN_DECISION_SERVICE: 
            case DMN_BKM_INVOCATION: {
                return DefaultAggregator.buildDefaultTraceExecutionStep(duration, afterEvent, children, type);
            }
            case DMN_CONTEXT_ENTRY: {
                return DefaultAggregator.buildDmnContextEntryTraceExecutionStep(duration, afterEvent, children, model);
            }
            case DMN_DECISION: {
                return DefaultAggregator.buildDmnDecisionTraceExecutionStep(duration, afterEvent, children);
            }
            case DMN_DECISION_TABLE: {
                return DefaultAggregator.buildDmnDecisionTableTraceExecutionStep(duration, afterEvent, children, model);
            }
        }
        return null;
    }

    private static TraceExecutionStep buildDefaultTraceExecutionStep(long duration, EvaluateEvent afterEvent, List<TraceExecutionStep> children, TraceExecutionStepType type) {
        HashMap<String, String> additionalData = new HashMap<String, String>();
        additionalData.put(NODE_ID_KEY, afterEvent.getNodeId());
        return new TraceExecutionStep(type, duration, afterEvent.getNodeName(), null, Collections.emptyList(), additionalData, children);
    }

    private static TraceExecutionStep buildDmnContextEntryTraceExecutionStep(long duration, EvaluateEvent afterEvent, List<TraceExecutionStep> children, DMNModel model) {
        JsonNode result = EventUtils.jsonNodeFrom(afterEvent.getContextEntryResult().getExpressionResult());
        HashMap<String, String> additionalData = new HashMap<String, String>();
        additionalData.put(EXPRESSION_ID_KEY, afterEvent.getContextEntryResult().getExpressionId());
        additionalData.put(VARIABLE_ID_KEY, afterEvent.getContextEntryResult().getVariableId());
        Optional<String> optDecisionNodeId = Optional.ofNullable(model).map(m -> m.getDecisionByName(afterEvent.getNodeName())).map(DMNNode::getId);
        if (optDecisionNodeId.isPresent()) {
            additionalData.put(NODE_ID_KEY, optDecisionNodeId.get());
        } else {
            additionalData.put(NODE_NAME_KEY, afterEvent.getNodeName());
        }
        return new TraceExecutionStep(TraceExecutionStepType.DMN_CONTEXT_ENTRY, duration, afterEvent.getContextEntryResult().getVariableName(), result, Collections.emptyList(), additionalData, children);
    }

    private static TraceExecutionStep buildDmnDecisionTraceExecutionStep(long duration, EvaluateEvent afterEvent, List<TraceExecutionStep> children) {
        List messages = afterEvent.getResult().getMessages().stream().filter(m -> afterEvent.getNodeId().equals(m.getSourceId())).collect(Collectors.toList());
        JsonNode result = afterEvent.getResult().getDecisionResults().stream().filter(dr -> dr.getDecisionId().equals(afterEvent.getNodeId())).findFirst().map(EvaluateDecisionResult::getResult).map(EventUtils::jsonNodeFrom).orElse(null);
        HashMap<String, String> additionalData = new HashMap<String, String>();
        additionalData.put(NODE_ID_KEY, afterEvent.getNodeId());
        return new TraceExecutionStep(TraceExecutionStepType.DMN_DECISION, duration, afterEvent.getNodeName(), result, messages, additionalData, children);
    }

    private static TraceExecutionStep buildDmnDecisionTableTraceExecutionStep(long duration, EvaluateEvent afterEvent, List<TraceExecutionStep> children, DMNModel model) {
        HashMap<String, String> additionalData = new HashMap<String, String>();
        additionalData.put(MATCHES_KEY, afterEvent.getDecisionTableResult().getMatches().stream().map(Object::toString).collect(Collectors.joining(",")));
        additionalData.put(SELECTED_KEY, afterEvent.getDecisionTableResult().getSelected().stream().map(Object::toString).collect(Collectors.joining(",")));
        Optional<String> optDecisionNodeId = Optional.ofNullable(model).map(m -> m.getDecisionByName(afterEvent.getNodeName())).map(DMNNode::getId);
        if (optDecisionNodeId.isPresent()) {
            additionalData.put(NODE_ID_KEY, optDecisionNodeId.get());
        } else {
            additionalData.put(NODE_NAME_KEY, afterEvent.getNodeName());
        }
        return new TraceExecutionStep(TraceExecutionStepType.DMN_DECISION_TABLE, duration, afterEvent.getDecisionTableResult().getDecisionTableName(), null, Collections.emptyList(), additionalData, children);
    }

    private static long computeDurationMillis(EvaluateEvent beginEvent, EvaluateEvent endEvent) {
        return Math.round((double)(endEvent.getNanoTime() - beginEvent.getNanoTime()) / 1000000.0);
    }

    private static TraceInputValue traceInputFrom(String name, Object value) {
        return new TraceInputValue(null, name, EventUtils.typedValueFrom(value), Collections.emptyList());
    }

    private static TraceInputValue traceInputFrom(InputDataNode node, Object value) {
        return new TraceInputValue(node.getId(), node.getName(), EventUtils.typedValueFrom(node.getType(), value), Collections.emptyList());
    }

    private static TraceOutputValue traceOutputFrom(EvaluateDecisionResult decisionResult, DMNModel model, Map<String, Object> context) {
        DMNType type = Optional.ofNullable(model).map(m -> m.getDecisionById(decisionResult.getDecisionId())).map(DecisionNode::getResultType).orElse(null);
        Map decisionInputTypes = Optional.ofNullable(model).map(m -> m.getDecisionById(decisionResult.getDecisionId())).filter(DMNBaseNode.class::isInstance).map(DMNBaseNode.class::cast).map(DMNBaseNode::getDependencies).map(deps -> deps.values().stream().map(DMNNode::getId).collect(Collectors.toList())).map(ids -> ids.stream().map(id -> DefaultAggregator.typeAndNameOf(id, model)).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getRight, Pair::getLeft))).orElseGet(HashMap::new);
        Map<String, TypedValue> decisionInputs = decisionInputTypes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> EventUtils.typedValueFrom((DMNType)e.getValue(), context.get(e.getKey()))));
        return new TraceOutputValue(decisionResult.getDecisionId(), decisionResult.getDecisionName(), decisionResult.getEvaluationStatus().name(), EventUtils.typedValueFrom(type, decisionResult.getResult()), decisionInputs, decisionResult.getMessages());
    }

    private static Pair<DMNType, String> typeAndNameOf(String nodeId, DMNModel model) {
        InputDataNode input = model.getInputById(nodeId);
        if (input != null) {
            return new Pair((Object)input.getType(), (Object)input.getName());
        }
        DecisionNode decision = model.getDecisionById(nodeId);
        if (decision != null) {
            return new Pair((Object)decision.getResultType(), (Object)decision.getName());
        }
        return null;
    }
}

