/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import com.fasterxml.jackson.core.type.TypeReference;
import io.cloudevents.v1.CloudEventImpl;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.management.GAV;
import org.kie.internal.decision.DecisionModelResource;
import org.kie.internal.decision.DecisionModelResourcesProvider;
import org.kie.kogito.decision.DecisionModelType;
import org.kie.kogito.tracing.decision.SpringBootModelEventEmitter;
import org.kie.kogito.tracing.decision.event.CloudEventUtils;
import org.kie.kogito.tracing.decision.event.model.ModelEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.kafka.core.KafkaTemplate;

public class SpringBootModelEventEmitterTest {
    private static final TypeReference<CloudEventImpl<ModelEvent>> CLOUD_EVENT_TYPE_REF = new TypeReference<CloudEventImpl<ModelEvent>>(){};
    private static final String TEST_TOPIC = "test-topic";

    @Test
    public void testEmitEvent() {
        KafkaTemplate mockedKarkaTemplate = (KafkaTemplate)Mockito.mock(KafkaTemplate.class);
        List<DecisionModelResource> models = Arrays.asList(this.makeModel(), this.makeModel());
        DecisionModelResourcesProvider mockedDecisionModelResourcesProvider = () -> models;
        SpringBootModelEventEmitter eventEmitter = new SpringBootModelEventEmitter(mockedDecisionModelResourcesProvider, mockedKarkaTemplate, TEST_TOPIC);
        eventEmitter.publishDecisionModels();
        ArgumentCaptor topicCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor payloadCaptor = ArgumentCaptor.forClass(String.class);
        ((KafkaTemplate)Mockito.verify((Object)mockedKarkaTemplate, (VerificationMode)Mockito.times((int)2))).send((String)topicCaptor.capture(), (Object)((String)payloadCaptor.capture()));
        topicCaptor.getAllValues().forEach(v -> Assertions.assertEquals((Object)TEST_TOPIC, (Object)v));
        String rawCloudEvent1 = (String)payloadCaptor.getAllValues().get(0);
        String rawCloudEvent2 = (String)payloadCaptor.getAllValues().get(1);
        CloudEventImpl cloudEvent1 = CloudEventUtils.decode((String)rawCloudEvent1, CLOUD_EVENT_TYPE_REF);
        CloudEventImpl cloudEvent2 = CloudEventUtils.decode((String)rawCloudEvent2, CLOUD_EVENT_TYPE_REF);
        Assertions.assertEquals((Object)"id", (Object)cloudEvent1.getAttributes().getId());
        Assertions.assertEquals((Object)"id", (Object)cloudEvent2.getAttributes().getId());
    }

    private DecisionModelResource makeModel() {
        DecisionModelResource model = (DecisionModelResource)Mockito.mock(DecisionModelResource.class);
        Mockito.when((Object)model.getGav()).thenReturn((Object)new GAV("groupId", "artifactId", "version"));
        Mockito.when((Object)model.getModelName()).thenReturn((Object)"name");
        Mockito.when((Object)model.getNamespace()).thenReturn((Object)"namespace");
        Mockito.when((Object)model.getModelType()).thenReturn((Object)DecisionModelType.DMN);
        Mockito.when((Object)((String)model.get())).thenReturn((Object)"model");
        return model;
    }
}

