/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.jackson.JsonFormat;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.kogito.Application;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.conf.StaticConfigBean;
import org.kie.kogito.decision.DecisionModels;
import org.kie.kogito.dmn.DMNKogito;
import org.kie.kogito.dmn.DmnDecisionModel;
import org.kie.kogito.tracing.decision.SpringBootDecisionTracingCollector;
import org.kie.kogito.tracing.decision.SpringBootDecisionTracingListener;
import org.kie.kogito.tracing.decision.SpringBootTraceEventEmitter;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEvent;
import org.kie.kogito.tracing.decision.event.trace.TraceEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.kafka.core.KafkaTemplate;

public class SpringBootDecisionTracingTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)JsonFormat.getCloudEventJacksonModule());
    private static final String TEST_EXECUTION_ID = "7c50581e-6e5b-407b-91d6-2ffb1d47ebc0";
    private static final String TEST_TOPIC = "test-topic";

    @Test
    public void test_ListenerAndCollector_UseRealEvents_Working() throws IOException {
        String serviceUrl = "localhost:8080";
        String modelResource = "/Traffic Violation.dmn";
        String modelNamespace = "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF";
        String modelName = "Traffic Violation";
        DMNRuntime runtime = DMNKogito.createGenericDMNRuntime((Reader[])new Reader[]{new InputStreamReader(SpringBootDecisionTracingTest.class.getResourceAsStream("/Traffic Violation.dmn"))});
        StaticConfigBean configBean = new StaticConfigBean("localhost:8080");
        ApplicationEventPublisher eventPublisher = (ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class);
        SpringBootDecisionTracingListener listener = new SpringBootDecisionTracingListener(eventPublisher);
        runtime.addListener((DMNRuntimeEventListener)listener);
        HashMap<String, Integer> driver = new HashMap<String, Integer>();
        driver.put("Age", 25);
        driver.put("Points", 10);
        HashMap<String, Object> violation = new HashMap<String, Object>();
        violation.put("Type", "speed");
        violation.put("Actual Speed", 105);
        violation.put("Speed Limit", 100);
        HashMap<String, HashMap<String, Object>> contextVariables = new HashMap<String, HashMap<String, Object>>();
        contextVariables.put("Driver", driver);
        contextVariables.put("Violation", violation);
        DmnDecisionModel model = new DmnDecisionModel(runtime, "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation", () -> TEST_EXECUTION_ID);
        DMNContext context = model.newContext(contextVariables);
        model.evaluateAll(context);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(EvaluateEvent.class);
        ((ApplicationEventPublisher)Mockito.verify((Object)eventPublisher, (VerificationMode)Mockito.times((int)14))).publishEvent(eventCaptor.capture());
        DecisionModels mockedDecisionModels = (DecisionModels)Mockito.mock(DecisionModels.class);
        Mockito.when((Object)mockedDecisionModels.getDecisionModel("https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation")).thenReturn((Object)model);
        Application mockedApplication = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)mockedApplication.decisionModels()).thenReturn((Object)mockedDecisionModels);
        KafkaTemplate template = (KafkaTemplate)Mockito.mock(KafkaTemplate.class);
        SpringBootTraceEventEmitter eventEmitter = new SpringBootTraceEventEmitter(template, TEST_TOPIC);
        SpringBootDecisionTracingCollector collector = new SpringBootDecisionTracingCollector(mockedApplication, eventEmitter, (ConfigBean)configBean);
        eventCaptor.getAllValues().forEach(arg_0 -> ((SpringBootDecisionTracingCollector)collector).onApplicationEvent(arg_0));
        ArgumentCaptor topicCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor payloadCaptor = ArgumentCaptor.forClass(String.class);
        ((KafkaTemplate)Mockito.verify((Object)template)).send((String)topicCaptor.capture(), (Object)((String)payloadCaptor.capture()));
        Assertions.assertEquals((Object)TEST_TOPIC, (Object)topicCaptor.getValue());
        CloudEvent cloudEvent = (CloudEvent)OBJECT_MAPPER.readValue((String)payloadCaptor.getValue(), CloudEvent.class);
        Assertions.assertEquals((Object)TEST_EXECUTION_ID, (Object)cloudEvent.getId());
        TraceEvent traceEvent = (TraceEvent)OBJECT_MAPPER.readValue(cloudEvent.getData(), TraceEvent.class);
        Assertions.assertNotNull((Object)traceEvent);
        Assertions.assertEquals((Object)"localhost:8080", (Object)traceEvent.getHeader().getResourceId().getServiceUrl());
    }
}

