/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import javax.annotation.PostConstruct;
import org.kie.internal.decision.DecisionModelResourcesProvider;
import org.kie.kogito.tracing.decision.BaseModelEventEmitter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class SpringBootModelEventEmitter
extends BaseModelEventEmitter {
    private final KafkaTemplate<String, String> template;
    private final String kafkaTopicName;

    @Autowired
    public SpringBootModelEventEmitter(DecisionModelResourcesProvider decisionModelResourcesProvider, KafkaTemplate<String, String> template, @Value(value="${kogito.addon.tracing.model.kafka.topic.name:kogito-tracing-model}") String kafkaTopicName) {
        super(decisionModelResourcesProvider);
        this.template = template;
        this.kafkaTopicName = kafkaTopicName;
    }

    @PostConstruct
    public void publishDecisionModels() {
        super.publishDecisionModels();
    }

    public void emit(String payload) {
        this.template.send(this.kafkaTopicName, (Object)payload);
    }
}

