/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.StringSerializer;
import org.kie.kogito.Application;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.tracing.decision.SpringBootDecisionTracingCollector;
import org.kie.kogito.tracing.decision.SpringBootDecisionTracingCollectorAsync;
import org.kie.kogito.tracing.decision.SpringBootTraceEventEmitter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaAdmin;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
public class SpringBootDecisionTracingConfiguration {
    private final String kafkaBootstrapAddress;
    private final String kafkaTopicName;
    private final int kafkaTopicPartitions;
    private final short kafkaTopicReplicationFactor;

    public SpringBootDecisionTracingConfiguration(@Value(value="${kogito.addon.tracing.decision.kafka.bootstrapAddress}") String kafkaBootstrapAddress, @Value(value="${kogito.addon.tracing.decision.kafka.topic.name:kogito-tracing-decision}") String kafkaTopicName, @Value(value="${kogito.addon.tracing.decision.kafka.topic.partitions:1}") int kafkaTopicPartitions, @Value(value="${kogito.addon.tracing.decision.kafka.topic.replicationFactor:1}") short kafkaTopicReplicationFactor) {
        this.kafkaBootstrapAddress = kafkaBootstrapAddress;
        this.kafkaTopicName = kafkaTopicName;
        this.kafkaTopicPartitions = kafkaTopicPartitions;
        this.kafkaTopicReplicationFactor = kafkaTopicReplicationFactor;
    }

    @Bean
    public SpringBootDecisionTracingCollector collector(SpringBootTraceEventEmitter eventEmitter, ConfigBean configBean, Application application, @Value(value="${kogito.addon.tracing.decision.asyncEnabled:true}") boolean asyncEnabled) {
        if (asyncEnabled) {
            return new SpringBootDecisionTracingCollectorAsync(eventEmitter, configBean, application);
        }
        return new SpringBootDecisionTracingCollector(eventEmitter, configBean, application);
    }

    @Bean
    public KafkaAdmin kafkaAdmin() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("bootstrap.servers", this.kafkaBootstrapAddress);
        return new KafkaAdmin(configs);
    }

    @Bean
    public NewTopic newTopic() {
        return new NewTopic(this.kafkaTopicName, this.kafkaTopicPartitions, this.kafkaTopicReplicationFactor);
    }

    @Bean
    public ProducerFactory<String, String> producerFactory() {
        HashMap<String, Object> configProps = new HashMap<String, Object>();
        configProps.put("bootstrap.servers", this.kafkaBootstrapAddress);
        configProps.put("key.serializer", StringSerializer.class);
        configProps.put("value.serializer", StringSerializer.class);
        return new DefaultKafkaProducerFactory(configProps);
    }

    @Bean
    public KafkaTemplate<String, String> kafkaTemplate() {
        return new KafkaTemplate(this.producerFactory());
    }

    @Bean(name={"kogitoTracingDecisionAddonTaskExecutor"})
    @ConditionalOnProperty(value={"kogito.addon.tracing.decision.asyncEnabled"}, havingValue="true", matchIfMissing=true)
    public Executor threadPoolTaskExecutor() {
        return Executors.newSingleThreadExecutor(r -> new Thread(r, "kogito-tracing"));
    }
}

