/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.message;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.impl.CloudEventUtils;
import io.cloudevents.core.message.StructuredMessageWriter;
import io.cloudevents.core.message.impl.GenericStructuredMessageReader;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.rw.CloudEventWriterFactory;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface MessageWriter<CEV extends CloudEventWriter<R>, R>
extends CloudEventWriterFactory<CEV, R>,
StructuredMessageWriter<R> {
    default public R writeStructured(CloudEvent event, String format) {
        GenericStructuredMessageReader message = GenericStructuredMessageReader.from(event, format);
        if (message == null) {
            throw new IllegalArgumentException("Format " + format + " not found");
        }
        return (R)message.read(this);
    }

    default public R writeStructured(CloudEvent event, EventFormat format) {
        return (R)GenericStructuredMessageReader.from(event, format).read(this);
    }

    default public R writeBinary(CloudEvent event) {
        return CloudEventUtils.toVisitable(event).read(this);
    }
}

