/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.common.classloader.ClassPathUtils;
import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigurableConfigSource;
import io.smallrye.config.SecuritySupport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

@Experimental(value="Loads sources by location")
public abstract class AbstractLocationConfigSourceLoader {
    private static final Converter<URI> URI_CONVERTER = new URIConverter();

    protected abstract String[] getFileExtensions();

    protected abstract ConfigSource loadConfigSource(URL var1, int var2) throws IOException;

    protected List<ConfigSource> loadConfigSources(String location, int ordinal) {
        return this.loadConfigSources(new String[]{location}, ordinal);
    }

    protected List<ConfigSource> loadConfigSources(String location, int ordinal, ClassLoader classLoader) {
        return this.loadConfigSources(new String[]{location}, ordinal, classLoader);
    }

    protected List<ConfigSource> loadConfigSources(String[] locations, int ordinal) {
        return this.loadConfigSources(locations, ordinal, SecuritySupport.getContextClassLoader());
    }

    protected List<ConfigSource> loadConfigSources(String[] locations, int ordinal, ClassLoader classLoader) {
        if (locations == null || locations.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        for (String location : locations) {
            URI uri = URI_CONVERTER.convert(location);
            if (uri.getScheme() == null) {
                configSources.addAll(this.tryFileSystem(uri, ordinal));
                configSources.addAll(this.tryClassPath(uri, ordinal, classLoader));
                continue;
            }
            if (uri.getScheme().equals("file")) {
                configSources.addAll(this.tryFileSystem(uri, ordinal));
                continue;
            }
            if (uri.getScheme().equals("jar")) {
                configSources.addAll(this.tryJar(uri, ordinal));
                continue;
            }
            if (uri.getScheme().startsWith("http")) {
                configSources.addAll(this.tryHttpResource(uri, ordinal));
                continue;
            }
            throw ConfigMessages.msg.schemeNotSupported(uri.getScheme());
        }
        return configSources;
    }

    protected List<ConfigSource> tryFileSystem(URI uri, int ordinal) {
        Path urlPath;
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        Path path = urlPath = uri.getScheme() != null ? Paths.get(uri) : Paths.get(uri.getPath(), new String[0]);
        if (Files.isRegularFile(urlPath, new LinkOption[0])) {
            ClassPathUtils.consumeAsPath(AbstractLocationConfigSourceLoader.toURL(urlPath.toUri()), new ConfigSourcePathConsumer(ordinal, configSources));
        } else if (Files.isDirectory(urlPath, new LinkOption[0])) {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(urlPath, this::validExtension);){
                for (Path path2 : paths) {
                    this.addConfigSource(path2.toUri(), ordinal, configSources);
                }
            }
            catch (IOException e) {
                throw ConfigMessages.msg.failedToLoadResource(e);
            }
        }
        return configSources;
    }

    protected List<ConfigSource> tryClassPath(URI uri, int ordinal, ClassLoader classLoader) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        ClassLoader useClassloader = classLoader != null ? classLoader : SecuritySupport.getContextClassLoader();
        try {
            ClassPathUtils.consumeAsPaths(useClassloader, uri.getPath(), new ConfigSourcePathConsumer(ordinal, configSources));
        }
        catch (IOException e) {
            throw ConfigMessages.msg.failedToLoadResource(e);
        }
        catch (IllegalArgumentException e) {
            configSources.addAll(this.fallbackToUnknownProtocol(uri, ordinal, useClassloader));
        }
        return configSources;
    }

    protected List<ConfigSource> tryJar(URI uri, int ordinal) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        try {
            ClassPathUtils.consumeAsPath(AbstractLocationConfigSourceLoader.toURL(uri), new ConfigSourcePathConsumer(ordinal, configSources));
        }
        catch (Exception e) {
            throw ConfigMessages.msg.failedToLoadResource(e);
        }
        return configSources;
    }

    protected List<ConfigSource> fallbackToUnknownProtocol(URI uri, int ordinal, ClassLoader classLoader) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        try {
            Enumeration<URL> resources = classLoader.getResources(uri.toString());
            while (resources.hasMoreElements()) {
                URL resourceUrl = resources.nextElement();
                if (!this.validExtension(resourceUrl.getFile())) continue;
                ConfigSource mainSource = this.addConfigSource(resourceUrl, ordinal, configSources);
                configSources.add(new ConfigurableConfigSource(profiles -> {
                    ArrayList<ConfigSource> profileSources = new ArrayList<ConfigSource>();
                    for (int i = profiles.size() - 1; i >= 0; --i) {
                        int mainOrdinal = mainSource.getOrdinal() + profiles.size() - i + 1;
                        URI profileUri = AbstractLocationConfigSourceLoader.addProfileName(uri, (String)profiles.get(i));
                        try {
                            Enumeration<URL> profileResources = classLoader.getResources(profileUri.toString());
                            while (profileResources.hasMoreElements()) {
                                URL profileUrl = profileResources.nextElement();
                                this.addProfileConfigSource(profileUrl, mainOrdinal, profileSources);
                            }
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return profileSources;
                }));
            }
        }
        catch (IOException e) {
            throw ConfigMessages.msg.failedToLoadResource(e);
        }
        return configSources;
    }

    protected List<ConfigSource> tryHttpResource(URI uri, int ordinal) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        if (this.validExtension(uri.getPath())) {
            ConfigSource mainSource = this.addConfigSource(uri, ordinal, configSources);
            configSources.addAll(this.tryProfiles(uri, mainSource));
        }
        return configSources;
    }

    protected List<ConfigSource> tryProfiles(URI uri, ConfigSource mainSource) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        configSources.add(new ConfigurableConfigSource(profiles -> {
            ArrayList<ConfigSource> profileSources = new ArrayList<ConfigSource>();
            for (int i = profiles.size() - 1; i >= 0; --i) {
                int ordinal = mainSource.getOrdinal() + profiles.size() - i;
                URI profileUri = AbstractLocationConfigSourceLoader.addProfileName(uri, (String)profiles.get(i));
                this.addProfileConfigSource(AbstractLocationConfigSourceLoader.toURL(profileUri), ordinal, profileSources);
            }
            return profileSources;
        }));
        return configSources;
    }

    private static URL toURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ConfigSource addConfigSource(URI uri, int ordinal, List<ConfigSource> configSources) {
        return this.addConfigSource(AbstractLocationConfigSourceLoader.toURL(uri), ordinal, configSources);
    }

    private ConfigSource addConfigSource(URL url, int ordinal, List<ConfigSource> configSources) {
        try {
            configSources.add(this.loadConfigSource(url, ordinal));
            return this.loadConfigSource(url, ordinal);
        }
        catch (IOException e) {
            throw ConfigMessages.msg.failedToLoadResource(e);
        }
    }

    private void addProfileConfigSource(URL profileToFileName, int ordinal, List<ConfigSource> profileSources) {
        try {
            profileSources.add(this.loadConfigSource(profileToFileName, ordinal));
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
        }
        catch (IOException e) {
            throw ConfigMessages.msg.failedToLoadResource(e);
        }
    }

    private boolean validExtension(Path fileName) {
        return this.validExtension(fileName.getFileName().toString());
    }

    private boolean validExtension(String resourceName) {
        for (String s : this.getFileExtensions()) {
            if (!resourceName.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    private static URI addProfileName(URI uri, String profile) {
        if ("jar".equals(uri.getScheme())) {
            return URI.create("jar:" + AbstractLocationConfigSourceLoader.addProfileName(URI.create(AbstractLocationConfigSourceLoader.decodeIfNeeded(uri).getRawSchemeSpecificPart()), profile));
        }
        String fileName = uri.getPath();
        assert (fileName != null);
        int dot = fileName.lastIndexOf(".");
        String fileNameProfile = dot != -1 && dot != 0 && fileName.charAt(dot - 1) != '/' ? fileName.substring(0, dot) + "-" + profile + fileName.substring(dot) : fileName + "-" + profile;
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), uri.getHost(), uri.getPort(), fileNameProfile, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Deprecated
    private static URI decodeIfNeeded(URI uri) {
        if (uri.getScheme().equals("jar")) {
            return URI.create(uri.getScheme() + ":" + uri.getSchemeSpecificPart());
        }
        return uri;
    }

    static interface ProfileConfigSourceFactory
    extends ConfigSourceFactory {
        @Override
        default public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
            List<String> profiles = context.getProfiles();
            if (profiles.isEmpty()) {
                return Collections.emptyList();
            }
            return this.getProfileConfigSources(profiles);
        }

        public Iterable<ConfigSource> getProfileConfigSources(List<String> var1);
    }

    private class ConfigSourcePathConsumer
    implements Consumer<Path> {
        private final List<ConfigSource> configSources;
        private final int ordinal;

        public ConfigSourcePathConsumer(int ordinal, List<ConfigSource> configSources) {
            this.ordinal = ordinal;
            this.configSources = configSources;
        }

        @Override
        public void accept(Path path) {
            AbstractLocationConfigSourceLoader loader = AbstractLocationConfigSourceLoader.this;
            if (loader.validExtension(path.getFileName().toString())) {
                ConfigSource mainSource = loader.addConfigSource(AbstractLocationConfigSourceLoader.decodeIfNeeded(path.toUri()), this.ordinal, (List<ConfigSource>)this.configSources);
                this.configSources.addAll(loader.tryProfiles(path.toUri(), mainSource));
            }
        }
    }

    private static class URIConverter
    implements Converter<URI> {
        private static final long serialVersionUID = -4852082279190307320L;

        private URIConverter() {
        }

        @Override
        public URI convert(String value) {
            try {
                return new URI(value);
            }
            catch (URISyntaxException e) {
                throw ConfigMessages.msg.uriSyntaxInvalid(e, value);
            }
        }
    }
}

