/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.microprofile.config.ResteasyConfigSource;

public class FilterConfigSourceImpl
implements ResteasyConfigSource {
    private volatile String name;

    @Override
    public Map<String, String> getProperties() {
        FilterConfig config = ResteasyContext.getContextData(FilterConfig.class);
        if (config == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration keys = config.getInitParameterNames();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                map.put(key, config.getInitParameter(key));
            }
        }
        return map;
    }

    @Override
    public Set<String> getPropertyNames() {
        FilterConfig config = ResteasyContext.getContextData(FilterConfig.class);
        if (config == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Collections.list(config.getInitParameterNames()));
    }

    @Override
    public String getValue(String propertyName) {
        FilterConfig config = ResteasyContext.getContextData(FilterConfig.class);
        if (config == null) {
            return null;
        }
        return config.getInitParameter(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        String currentName = this.name;
        if (currentName == null) {
            FilterConfigSourceImpl filterConfigSourceImpl = this;
            synchronized (filterConfigSourceImpl) {
                currentName = this.name;
                if (currentName == null) {
                    ServletContext servletContext = ResteasyContext.getContextData(ServletContext.class);
                    FilterConfig filterConfig = ResteasyContext.getContextData(FilterConfig.class);
                    StringBuilder sb = new StringBuilder();
                    this.name = currentName = sb.append(servletContext != null ? servletContext.getServletContextName() : null).append(":").append(filterConfig != null ? filterConfig.getFilterName() : null).append(":FilterConfigSource").toString();
                }
            }
        }
        return currentName;
    }

    @Override
    public int getDefaultOrdinal() {
        return 50;
    }
}

