/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.redis.index;

import io.redisearch.Client;
import io.redisearch.Schema;
import io.redisearch.client.Client;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.persistence.redis.RedisClientManager;
import org.kie.kogito.persistence.redis.index.RedisCreateIndexEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.exceptions.JedisDataException;

@ApplicationScoped
public class RedisIndexManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisIndexManager.class);
    private final RedisClientManager redisClientManager;
    private Map<String, List<String>> indexes;

    public RedisIndexManager() {
    }

    @Inject
    public RedisIndexManager(RedisClientManager redisClientManager) {
        this.indexes = new HashMap<String, List<String>>();
        this.redisClientManager = redisClientManager;
    }

    public void createIndex(RedisCreateIndexEvent event) {
        Client client = this.redisClientManager.getClient(event.getIndexName());
        this.indexes.put(event.getIndexName(), event.getFields().stream().map(field -> field.name).collect(Collectors.toList()));
        Schema schema = new Schema();
        event.getFields().forEach(schema::addField);
        schema.addField(new Schema.Field("indexName", Schema.FieldType.FullText, false));
        try {
            client.createIndex(schema, Client.IndexOptions.defaultOptions());
        }
        catch (JedisDataException ignored) {
            LOGGER.info(String.format("Could not add redis index %s, it probably already exists.", event.getIndexName()));
        }
    }

    public List<String> getSchema(String indexName) {
        return this.indexes.get(indexName);
    }
}

