/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.trusty.storage.api.model.CounterfactualSearchDomain;
import org.kie.kogito.trusty.storage.api.model.TypedVariable;
import org.kie.kogito.trusty.storage.api.model.TypedVariableWithValue;

public class CounterfactualParameterValidation {
    private static final IdenticalCheck IDENTICAL = new IdenticalCheck();
    private static final SubsetCheck SUBSET = new SubsetCheck();

    private CounterfactualParameterValidation() {
    }

    public static boolean isStructureIdentical(Collection<TypedVariableWithValue> inputs, Collection<CounterfactualSearchDomain> searchDomains) {
        return IDENTICAL.check(inputs, searchDomains);
    }

    public static boolean isStructureSubset(Collection<TypedVariableWithValue> outcomes, Collection<TypedVariableWithValue> goals) {
        return SUBSET.check(outcomes, goals);
    }

    private static class StructureHolder<T extends TypedVariable<T>> {
        private final TypedValue.Kind kind;
        private final String name;
        private final String typeRef;
        private final T original;

        public StructureHolder(T typedVariableWithValue) {
            this.kind = ((TypedVariable)typedVariableWithValue).getKind();
            this.name = ((TypedVariable)typedVariableWithValue).getName();
            this.typeRef = ((TypedVariable)typedVariableWithValue).getTypeRef();
            this.original = typedVariableWithValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructureHolder that = (StructureHolder)o;
            return this.kind == that.kind && Objects.equals(this.name, that.name) && Objects.equals(this.typeRef, that.typeRef);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.name, this.typeRef});
        }
    }

    private static class SubsetCheck
    extends BaseCheck<TypedVariableWithValue, TypedVariableWithValue> {
        private SubsetCheck() {
        }

        @Override
        protected boolean checkMembership(Map<String, StructureHolder<TypedVariableWithValue>> structure1Map, Map<String, StructureHolder<TypedVariableWithValue>> structure2Map) {
            boolean validSize = structure2Map.size() <= structure1Map.size();
            boolean validEntries = structure2Map.entrySet().stream().allMatch(e -> Objects.equals(e.getValue(), structure1Map.get(e.getKey())));
            return validSize && validEntries;
        }
    }

    private static class IdenticalCheck
    extends BaseCheck<TypedVariableWithValue, CounterfactualSearchDomain> {
        private IdenticalCheck() {
        }

        @Override
        protected boolean checkMembership(Map<String, StructureHolder<TypedVariableWithValue>> structure1Map, Map<String, StructureHolder<CounterfactualSearchDomain>> structure2Map) {
            boolean validSize = structure2Map.size() == structure1Map.size();
            boolean validEntries = structure1Map.entrySet().stream().allMatch(e -> Objects.equals(e.getValue(), structure2Map.get(e.getKey())));
            return validSize && validEntries;
        }
    }

    private static abstract class BaseCheck<D extends TypedVariable<D>, C extends TypedVariable<C>>
    implements Check<D, C> {
        private BaseCheck() {
        }

        @Override
        public boolean check(Collection<D> structure1, Collection<C> structure2) {
            Map<String, StructureHolder<C>> structure2Map;
            if (Objects.isNull(structure1) && Objects.isNull(structure2)) {
                return true;
            }
            if (Objects.isNull(structure1)) {
                return false;
            }
            if (Objects.isNull(structure2)) {
                return false;
            }
            if (structure1.isEmpty() && structure2.isEmpty()) {
                return true;
            }
            Map<String, StructureHolder<D>> structure1Map = structure1.stream().map(StructureHolder::new).collect(Collectors.toMap(ih -> ih.name, ih -> ih));
            if (!this.checkMembership(structure1Map, structure2Map = structure2.stream().map(StructureHolder::new).collect(Collectors.toMap(ih -> ih.name, ih -> ih)))) {
                return false;
            }
            Collection structure1ChildStructures = structure1Map.values().stream().filter(e -> e.kind == TypedValue.Kind.STRUCTURE).map(ih -> ((TypedVariable)ih.original).getComponents()).flatMap(Collection::stream).collect(Collectors.toList());
            Collection structure2ChildStructures = structure2Map.values().stream().filter(e -> e.kind == TypedValue.Kind.STRUCTURE).map(ih -> ((TypedVariable)ih.original).getComponents()).flatMap(Collection::stream).collect(Collectors.toList());
            return this.check(structure1ChildStructures, structure2ChildStructures);
        }

        protected abstract boolean checkMembership(Map<String, StructureHolder<D>> var1, Map<String, StructureHolder<C>> var2);
    }

    private static interface Check<D extends TypedVariable<D>, C extends TypedVariable<C>> {
        public boolean check(Collection<D> var1, Collection<C> var2);
    }
}

