/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.kie.pmml.api.enums.BUILTIN_FUNCTIONS;
import org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;

public class KiePMMLApply
extends AbstractKiePMMLComponent
implements KiePMMLExpression {
    private static final long serialVersionUID = -6975232157053159223L;
    private final String function;
    private String mapMissingTo;
    private String defaultValue;
    private INVALID_VALUE_TREATMENT_METHOD invalidValueTreatmentMethod;
    private List<KiePMMLExpression> kiePMMLExpressions;

    private KiePMMLApply(String name, List<KiePMMLExtension> extensions, String function) {
        super(name, extensions);
        this.function = function;
    }

    public static Builder builder(String name, List<KiePMMLExtension> extensions, String function) {
        return new Builder(name, extensions, function);
    }

    @Override
    public Object evaluate(ProcessingDTO processingDTO) {
        if (this.kiePMMLExpressions == null) {
            return null;
        }
        ArrayList<Object> expressionValues = new ArrayList<Object>();
        for (KiePMMLExpression kiePMMLExpression : this.kiePMMLExpressions) {
            expressionValues.add(kiePMMLExpression.evaluate(processingDTO));
        }
        if (BUILTIN_FUNCTIONS.isBUILTIN_FUNCTIONS(this.function)) {
            BUILTIN_FUNCTIONS builtinFunction = BUILTIN_FUNCTIONS.byName(this.function);
            return builtinFunction.getValue(expressionValues.toArray(new Object[0]));
        }
        KiePMMLDefineFunction definedFunction = processingDTO.getDefineFunctions().stream().filter(defineFunction -> defineFunction.getName().equals(this.function)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown function " + this.function));
        return definedFunction.evaluate(processingDTO, expressionValues);
    }

    public String getFunction() {
        return this.function;
    }

    public String getMapMissingTo() {
        return this.mapMissingTo;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public INVALID_VALUE_TREATMENT_METHOD getInvalidValueTreatmentMethod() {
        return this.invalidValueTreatmentMethod;
    }

    public List<KiePMMLExpression> getKiePMMLExpressions() {
        return this.kiePMMLExpressions != null ? Collections.unmodifiableList(this.kiePMMLExpressions) : Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KiePMMLApply that = (KiePMMLApply)o;
        return Objects.equals(this.function, that.function) && Objects.equals(this.mapMissingTo, that.mapMissingTo) && Objects.equals(this.defaultValue, that.defaultValue) && this.invalidValueTreatmentMethod == that.invalidValueTreatmentMethod && Objects.equals(this.kiePMMLExpressions, that.kiePMMLExpressions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.function, this.mapMissingTo, this.defaultValue, this.invalidValueTreatmentMethod, this.kiePMMLExpressions});
    }

    public String toString() {
        return new StringJoiner(", ", KiePMMLApply.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("extensions=" + this.extensions).add("id='" + this.id + "'").add("parentId='" + this.parentId + "'").add("function='" + this.function + "'").add("mapMissingTo='" + this.mapMissingTo + "'").add("defaultValue='" + this.defaultValue + "'").add("invalidValueTreatmentMethod=" + (Object)((Object)this.invalidValueTreatmentMethod)).add("kiePMMLExpressions=" + this.kiePMMLExpressions).toString();
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLApply> {
        private Builder(String name, List<KiePMMLExtension> extensions, String function) {
            super("Apply-", () -> new KiePMMLApply(name, extensions, function));
        }

        public Builder withMapMissingTo(String mapMissingTo) {
            if (mapMissingTo != null) {
                ((KiePMMLApply)this.toBuild).mapMissingTo = mapMissingTo;
            }
            return this;
        }

        public Builder withDefaultValue(String defaultValue) {
            if (defaultValue != null) {
                ((KiePMMLApply)this.toBuild).defaultValue = defaultValue;
            }
            return this;
        }

        public Builder withInvalidValueTreatmentMethod(String invalidValueTreatment) {
            if (invalidValueTreatment != null) {
                ((KiePMMLApply)this.toBuild).invalidValueTreatmentMethod = INVALID_VALUE_TREATMENT_METHOD.byName(invalidValueTreatment);
            }
            return this;
        }

        public Builder withKiePMMLExpressions(List<KiePMMLExpression> kiePMMLExpressions) {
            if (kiePMMLExpressions != null) {
                ((KiePMMLApply)this.toBuild).kiePMMLExpressions = kiePMMLExpressions;
            }
            return this;
        }
    }
}

