/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jackson.runtime.vertx;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import io.quarkus.jackson.runtime.vertx.JsonUtil;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.time.Instant;

class BufferDeserializer
extends JsonDeserializer<Buffer> {
    BufferDeserializer() {
    }

    @Override
    public Buffer deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String text = p.getText();
        try {
            return Buffer.buffer(JsonUtil.BASE64_DECODER.decode(text));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(p, "Expected a base64 encoded byte array", (Object)text, Instant.class);
        }
    }
}

