/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.osgi;

import java.net.URL;
import org.kie.api.internal.utils.ServiceDiscoveryImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class BaseActivator
implements BundleActivator {
    private final ClassLoader classLoader;
    private ServiceTracker serviceDiscoveryTracker;

    protected BaseActivator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void start(BundleContext context) throws Exception {
        this.serviceDiscoveryTracker = new ServiceTracker(context, ServiceDiscoveryImpl.class.getName(), (ServiceTrackerCustomizer)new ServiceDiscoveryTracker(context, this.classLoader));
        this.serviceDiscoveryTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.serviceDiscoveryTracker.close();
    }

    public static class ServiceDiscoveryTracker
    implements ServiceTrackerCustomizer<ServiceDiscoveryImpl, ServiceDiscoveryImpl> {
        private final BundleContext context;
        private ClassLoader classLoader;

        public ServiceDiscoveryTracker(BundleContext context, ClassLoader classLoader) {
            this.context = context;
            this.classLoader = classLoader;
        }

        public ServiceDiscoveryImpl addingService(ServiceReference<ServiceDiscoveryImpl> ref) {
            ServiceDiscoveryImpl service = (ServiceDiscoveryImpl)this.context.getService(ref);
            URL kieConfUrl = ServiceDiscoveryImpl.getKieConfsFromKnownModules(this.classLoader).findFirst().orElse(this.classLoader.getResource("META-INF/kie.conf"));
            if (kieConfUrl != null) {
                service.registerConfs(this.classLoader, kieConfUrl);
            }
            return service;
        }

        public void modifiedService(ServiceReference<ServiceDiscoveryImpl> reference, ServiceDiscoveryImpl service) {
        }

        public void removedService(ServiceReference<ServiceDiscoveryImpl> reference, ServiceDiscoveryImpl service) {
        }
    }
}

