/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.expressions.ExpressionsUtils;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldColumnPair;
import org.kie.pmml.commons.model.expressions.KiePMMLInlineTable;

public class KiePMMLMapValues
extends AbstractKiePMMLComponent
implements KiePMMLExpression {
    private static final long serialVersionUID = 4576394527423997787L;
    private final String outputColumn;
    private KiePMMLInlineTable inlineTable;
    private List<KiePMMLFieldColumnPair> fieldColumnPairs = new ArrayList<KiePMMLFieldColumnPair>();
    private String defaultValue;
    private String mapMissingTo;
    private DATA_TYPE dataType;

    private KiePMMLMapValues(String name, List<KiePMMLExtension> extensions, String outputColumn) {
        super(name, extensions);
        this.outputColumn = outputColumn;
    }

    public static Builder builder(String name, List<KiePMMLExtension> extensions, String outputColumn) {
        return new Builder(name, extensions, outputColumn);
    }

    @Override
    public Object evaluate(ProcessingDTO processingDTO) {
        HashMap<String, Object> columnPairsMap = new HashMap<String, Object>();
        for (KiePMMLFieldColumnPair kiePMMLFieldColumnPair : this.fieldColumnPairs) {
            Optional<Object> value = ExpressionsUtils.getFromPossibleSources(kiePMMLFieldColumnPair.getName(), processingDTO);
            if (value.isPresent()) {
                columnPairsMap.put(kiePMMLFieldColumnPair.getColumn(), value.get());
                continue;
            }
            return this.mapMissingTo;
        }
        Optional<Object> retrieved = Optional.empty();
        if (this.inlineTable != null) {
            retrieved = this.inlineTable.evaluate(columnPairsMap, this.outputColumn, null);
        }
        return retrieved.orElse(this.defaultValue);
    }

    public String toString() {
        return new StringJoiner(", ", KiePMMLMapValues.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("outputColumn='" + this.outputColumn + "'").add("inlineTable=" + this.inlineTable).add("defaultValue='" + this.defaultValue + "'").add("mapMissingTo='" + this.mapMissingTo + "'").add("dataType=" + (Object)((Object)this.dataType)).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KiePMMLMapValues that = (KiePMMLMapValues)o;
        return Objects.equals(this.outputColumn, that.outputColumn) && Objects.equals(this.inlineTable, that.inlineTable) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.mapMissingTo, that.mapMissingTo) && this.dataType == that.dataType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.outputColumn, this.inlineTable, this.defaultValue, this.mapMissingTo, this.dataType});
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLMapValues> {
        private Builder(String name, List<KiePMMLExtension> extensions, String outputColumn) {
            super("MapValues-", () -> new KiePMMLMapValues(name, extensions, outputColumn));
        }

        public Builder withMapMissingTo(String mapMissingTo) {
            if (mapMissingTo != null) {
                ((KiePMMLMapValues)this.toBuild).mapMissingTo = mapMissingTo;
            }
            return this;
        }

        public Builder withDefaultValue(String defaultValue) {
            if (defaultValue != null) {
                ((KiePMMLMapValues)this.toBuild).defaultValue = defaultValue;
            }
            return this;
        }

        public Builder withKiePMMLInlineTable(KiePMMLInlineTable inlineTable) {
            if (inlineTable != null) {
                ((KiePMMLMapValues)this.toBuild).inlineTable = inlineTable;
            }
            return this;
        }

        public Builder withKiePMMLFieldColumnPairs(List<KiePMMLFieldColumnPair> fieldColumnPairs) {
            if (fieldColumnPairs != null) {
                ((KiePMMLMapValues)this.toBuild).fieldColumnPairs = fieldColumnPairs;
            }
            return this;
        }

        public Builder withDataType(DATA_TYPE dataType) {
            if (dataType != null) {
                ((KiePMMLMapValues)this.toBuild).dataType = dataType;
            }
            return this;
        }
    }
}

