/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.streams.stages;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.streams.Engine;
import io.smallrye.mutiny.streams.operators.ProcessingStage;
import io.smallrye.mutiny.streams.operators.ProcessingStageFactory;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.reactivestreams.Publisher;

public class OnErrorResumeWithStageFactory
implements ProcessingStageFactory<Stage.OnErrorResumeWith> {
    @Override
    public <I, O> ProcessingStage<I, O> create(Engine engine, Stage.OnErrorResumeWith stage) {
        Function<Throwable, Graph> function = Objects.requireNonNull(stage).getFunction();
        Objects.requireNonNull(function);
        return source -> source.onFailure().recoverWithMulti(failure -> {
            Graph graph = (Graph)function.apply((Throwable)failure);
            Publisher publisher = engine.buildPublisher(Objects.requireNonNull(graph));
            return Multi.createFrom().publisher(publisher);
        });
    }
}

