/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationContext;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthorizationHandler;
import io.vertx.ext.web.handler.HttpException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;

public class AuthorizationHandlerImpl
implements AuthorizationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationHandler.class);
    private static final int FORBIDDEN_CODE = 403;
    private static final HttpException FORBIDDEN_EXCEPTION = new HttpException(403);
    private final Authorization authorization;
    private final Collection<AuthorizationProvider> authorizationProviders;
    private BiConsumer<RoutingContext, AuthorizationContext> variableHandler;

    public AuthorizationHandlerImpl(Authorization authorization) {
        this.authorization = Objects.requireNonNull(authorization);
        this.authorizationProviders = new ArrayList<AuthorizationProvider>();
    }

    @Override
    public void handle(RoutingContext routingContext) {
        if (routingContext.user() == null) {
            routingContext.fail(403, FORBIDDEN_EXCEPTION);
        } else {
            routingContext.request().pause();
            try {
                AuthorizationContext authorizationContext = this.getAuthorizationContext(routingContext);
                this.checkOrFetchAuthorizations(routingContext, authorizationContext, this.authorizationProviders.iterator());
            }
            catch (RuntimeException e) {
                routingContext.request().resume();
                routingContext.fail(e);
            }
        }
    }

    @Override
    public AuthorizationHandler variableConsumer(BiConsumer<RoutingContext, AuthorizationContext> handler) {
        this.variableHandler = handler;
        return this;
    }

    private void checkOrFetchAuthorizations(RoutingContext routingContext, AuthorizationContext authorizationContext, Iterator<AuthorizationProvider> providers) {
        if (this.authorization.match(authorizationContext)) {
            routingContext.request().resume();
            routingContext.next();
            return;
        }
        if (!providers.hasNext()) {
            routingContext.request().resume();
            routingContext.fail(403, FORBIDDEN_EXCEPTION);
            return;
        }
        while (providers.hasNext()) {
            AuthorizationProvider provider = providers.next();
            if (routingContext.user().authorizations().getProviderIds().contains(provider.getId())) continue;
            provider.getAuthorizations(routingContext.user(), authorizationResult -> {
                if (authorizationResult.failed()) {
                    LOG.warn("An error occured getting authorization - providerId: " + provider.getId(), authorizationResult.cause());
                }
                this.checkOrFetchAuthorizations(routingContext, authorizationContext, providers);
            });
            return;
        }
    }

    private AuthorizationContext getAuthorizationContext(RoutingContext event) {
        AuthorizationContext result = AuthorizationContext.create(event.user());
        if (this.variableHandler != null) {
            this.variableHandler.accept(event, result);
        }
        return result;
    }

    @Override
    public AuthorizationHandler addAuthorizationProvider(AuthorizationProvider authorizationProvider) {
        Objects.requireNonNull(authorizationProvider);
        this.authorizationProviders.add(authorizationProvider);
        return this;
    }
}

