/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.auth.authorization;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mutiny.ext.auth.User;
import io.vertx.mutiny.ext.auth.authorization.Authorization;
import java.util.Set;
import java.util.stream.Collectors;

@MutinyGen(value=io.vertx.ext.auth.authorization.AuthorizationProvider.class)
public class AuthorizationProvider {
    public static final TypeArg<AuthorizationProvider> __TYPE_ARG = new TypeArg<AuthorizationProvider>(obj -> new AuthorizationProvider((io.vertx.ext.auth.authorization.AuthorizationProvider)obj), AuthorizationProvider::getDelegate);
    private final io.vertx.ext.auth.authorization.AuthorizationProvider delegate;

    public AuthorizationProvider(io.vertx.ext.auth.authorization.AuthorizationProvider delegate) {
        this.delegate = delegate;
    }

    public AuthorizationProvider(Object delegate) {
        this.delegate = (io.vertx.ext.auth.authorization.AuthorizationProvider)delegate;
    }

    AuthorizationProvider() {
        this.delegate = null;
    }

    public io.vertx.ext.auth.authorization.AuthorizationProvider getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationProvider that = (AuthorizationProvider)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static AuthorizationProvider create(String id, Set<Authorization> authorizations) {
        AuthorizationProvider ret = AuthorizationProvider.newInstance(io.vertx.ext.auth.authorization.AuthorizationProvider.create(id, authorizations.stream().map(elt -> elt.getDelegate()).collect(Collectors.toSet())));
        return ret;
    }

    public String getId() {
        String ret = this.delegate.getId();
        return ret;
    }

    public Uni<Void> getAuthorizations(User user) {
        return AsyncResultUni.toUni(handler -> this.delegate.getAuthorizations(user.getDelegate(), (Handler<AsyncResult<Void>>)handler));
    }

    public Void getAuthorizationsAndAwait(User user) {
        return this.getAuthorizations(user).await().indefinitely();
    }

    public void getAuthorizationsAndForget(User user) {
        this.getAuthorizations(user).subscribe().with(UniHelper.NOOP);
    }

    public static AuthorizationProvider newInstance(io.vertx.ext.auth.authorization.AuthorizationProvider arg) {
        return arg != null ? new AuthorizationProvider(arg) : null;
    }
}

