/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.security.OAuthFlowImpl;
import io.smallrye.openapi.api.models.security.OAuthFlowsImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionConstant;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class OAuthReader {
    private OAuthReader() {
    }

    public static OAuthFlows readOAuthFlows(AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return null;
        }
        IoLogging.logger.singleAnnotation("@OAuthFlows");
        AnnotationInstance annotation = annotationValue.asNested();
        OAuthFlowsImpl flows = new OAuthFlowsImpl();
        flows.setImplicit(OAuthReader.readOAuthFlow(annotation.value("implicit")));
        flows.setPassword(OAuthReader.readOAuthFlow(annotation.value("password")));
        flows.setClientCredentials(OAuthReader.readOAuthFlow(annotation.value("clientCredentials")));
        flows.setAuthorizationCode(OAuthReader.readOAuthFlow(annotation.value("authorizationCode")));
        return flows;
    }

    public static OAuthFlows readOAuthFlows(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.singleJsonObject("OAuthFlows");
        OAuthFlowsImpl flows = new OAuthFlowsImpl();
        flows.setImplicit(OAuthReader.readOAuthFlow(node.get("implicit")));
        flows.setPassword(OAuthReader.readOAuthFlow(node.get("password")));
        flows.setClientCredentials(OAuthReader.readOAuthFlow(node.get("clientCredentials")));
        flows.setAuthorizationCode(OAuthReader.readOAuthFlow(node.get("authorizationCode")));
        ExtensionReader.readExtensions(node, flows);
        return flows;
    }

    private static OAuthFlow readOAuthFlow(AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return null;
        }
        IoLogging.logger.singleAnnotation("@OAuthFlow");
        AnnotationInstance annotation = annotationValue.asNested();
        OAuthFlowImpl flow = new OAuthFlowImpl();
        flow.setAuthorizationUrl(JandexUtil.stringValue(annotation, "authorizationUrl"));
        flow.setTokenUrl(JandexUtil.stringValue(annotation, "tokenUrl"));
        flow.setRefreshUrl(JandexUtil.stringValue(annotation, "refreshUrl"));
        flow.setScopes(OAuthReader.readOAuthScopes(annotation.value("scopes")));
        return flow;
    }

    private static OAuthFlow readOAuthFlow(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.singleJsonObject("OAuthFlow");
        OAuthFlowImpl flow = new OAuthFlowImpl();
        flow.setAuthorizationUrl(JsonUtil.stringProperty(node, "authorizationUrl"));
        flow.setTokenUrl(JsonUtil.stringProperty(node, "tokenUrl"));
        flow.setRefreshUrl(JsonUtil.stringProperty(node, "refreshUrl"));
        flow.setScopes(OAuthReader.readOAuthScopes(node.get("scopes")));
        ExtensionReader.readExtensions(node, flow);
        return flow;
    }

    private static Map<String, String> readOAuthScopes(AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return null;
        }
        IoLogging.logger.annotationsList("@OAuthScope");
        AnnotationInstance[] nestedArray = annotationValue.asNestedArray();
        LinkedHashMap<String, String> scopes = new LinkedHashMap<String, String>();
        for (AnnotationInstance nested : nestedArray) {
            String name = JandexUtil.stringValue(nested, "name");
            if (name == null) continue;
            String description = JandexUtil.stringValue(nested, "description");
            scopes.put(name, description);
        }
        return scopes;
    }

    public static Map<String, String> readOAuthScopes(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.jsonMap("OAuthScope");
        LinkedHashMap<String, String> scopes = new LinkedHashMap<String, String>();
        Iterator<String> fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = fieldNames.next();
            if (ExtensionConstant.isExtensionField(fieldName)) continue;
            String value = JsonUtil.stringProperty(node, fieldName);
            scopes.put(fieldName, value);
        }
        return scopes;
    }
}

