/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.helpers;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.helpers.TypeUtils;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Prioritized;
import org.eclipse.microprofile.reactive.messaging.Message;

public class ConverterUtils {
    private ConverterUtils() {
    }

    public static Multi<? extends Message<?>> convert(Multi<? extends Message<?>> upstream, final Instance<MessageConverter> converters, final Type injectedPayloadType) {
        if (injectedPayloadType != null) {
            return upstream.map(new Function<Message<?>, Message<?>>(){
                MessageConverter actual;

                @Override
                public Message<?> apply(Message<?> o) {
                    if (injectedPayloadType == null) {
                        return o;
                    }
                    if (o.getPayload() != null && o.getPayload().getClass().equals(injectedPayloadType)) {
                        return o;
                    }
                    if (this.actual != null) {
                        return this.actual.convert(o, injectedPayloadType);
                    }
                    if (o.getPayload() != null && TypeUtils.isAssignable(o.getPayload().getClass(), injectedPayloadType)) {
                        this.actual = MessageConverter.IdentityConverter.INSTANCE;
                        return o;
                    }
                    for (MessageConverter conv : ConverterUtils.getSortedConverters(converters)) {
                        if (!conv.canConvert(o, injectedPayloadType)) continue;
                        this.actual = conv;
                        return this.actual.convert(o, injectedPayloadType);
                    }
                    return o;
                }
            });
        }
        return upstream;
    }

    private static List<MessageConverter> getSortedConverters(Instance<MessageConverter> converters) {
        if (converters.isUnsatisfied()) {
            return Collections.emptyList();
        }
        return converters.stream().sorted(new Comparator<MessageConverter>(){

            @Override
            public int compare(MessageConverter si1, MessageConverter si2) {
                int p1 = 0;
                int p2 = 0;
                if (si1 instanceof Prioritized) {
                    p1 = si1.getPriority();
                }
                if (si2 instanceof Prioritized) {
                    p2 = si2.getPriority();
                }
                if (si1.equals(si2)) {
                    return 0;
                }
                return Integer.compare(p1, p2);
            }
        }).collect(Collectors.toList());
    }
}

