/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kie.kogito.explainability.api.CounterfactualSearchDomain;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainStructureValue;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainValue;
import org.kie.kogito.explainability.api.NamedTypedValue;
import org.kie.kogito.tracing.typedvalue.BaseTypedValue;
import org.kie.kogito.tracing.typedvalue.StructureValue;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.trusty.storage.api.model.DecisionInput;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;

public class CounterfactualParameterValidation {
    private static final IdenticalCheck IDENTICAL = new IdenticalCheck();
    private static final SubsetCheck SUBSET = new SubsetCheck();

    private CounterfactualParameterValidation() {
    }

    public static boolean isStructureIdentical(Collection<DecisionInput> inputs, Collection<CounterfactualSearchDomain> searchDomains) {
        return IDENTICAL.check(inputs, searchDomains);
    }

    public static boolean isStructureSubset(Collection<DecisionOutcome> outcomes, Collection<NamedTypedValue> goals) {
        return SUBSET.check(outcomes, goals);
    }

    private static class StructureHolder<T> {
        private final BaseTypedValue.Kind kind;
        private final String name;
        private final String typeRef;
        private final T original;

        public StructureHolder(BaseTypedValue.Kind kind, String name, String typeRef, T original) {
            this.kind = kind;
            this.name = name;
            this.typeRef = typeRef;
            this.original = original;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructureHolder that = (StructureHolder)o;
            return this.kind == that.kind && Objects.equals(this.name, that.name) && Objects.equals(this.typeRef, that.typeRef);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.name, this.typeRef});
        }
    }

    private static class SubsetCheck
    extends BaseCheck<DecisionOutcome, TypedValue, NamedTypedValue, TypedValue> {
        private SubsetCheck() {
        }

        @Override
        protected boolean checkMembership(Map<String, StructureHolder<TypedValue>> structure1Map, Map<String, StructureHolder<TypedValue>> structure2Map) {
            boolean validSize = structure2Map.size() <= structure1Map.size();
            boolean validEntries = structure2Map.entrySet().stream().allMatch(e -> Objects.equals(e.getValue(), structure1Map.get(e.getKey())));
            return validSize && validEntries;
        }

        @Override
        protected StructureHolder<TypedValue> convertStructure1toHolder(DecisionOutcome value) {
            return new StructureHolder<TypedValue>(value.getOutcomeResult().getKind(), value.getOutcomeName(), value.getOutcomeResult().getType(), value.getOutcomeResult());
        }

        @Override
        protected StructureHolder<TypedValue> convertStructure2toHolder(NamedTypedValue value) {
            return new StructureHolder<TypedValue>(value.getValue().getKind(), value.getName(), value.getValue().getType(), value.getValue());
        }

        @Override
        protected Collection<StructureHolder<TypedValue>> getChildrenOfStructure1(TypedValue value) {
            if (value.getKind() != BaseTypedValue.Kind.STRUCTURE) {
                return Collections.emptyList();
            }
            return ((StructureValue)value.toStructure()).getValue().entrySet().stream().map(e -> new StructureHolder<TypedValue>(((TypedValue)e.getValue()).getKind(), (String)e.getKey(), ((TypedValue)e.getValue()).getType(), (TypedValue)e.getValue())).collect(Collectors.toList());
        }

        @Override
        protected Collection<StructureHolder<TypedValue>> getChildrenOfStructure2(TypedValue value) {
            return this.getChildrenOfStructure1(value);
        }
    }

    private static class IdenticalCheck
    extends BaseCheck<DecisionInput, TypedValue, CounterfactualSearchDomain, CounterfactualSearchDomainValue> {
        private IdenticalCheck() {
        }

        @Override
        protected boolean checkMembership(Map<String, StructureHolder<TypedValue>> structure1Map, Map<String, StructureHolder<CounterfactualSearchDomainValue>> structure2Map) {
            boolean validSize = structure2Map.size() == structure1Map.size();
            boolean validEntries = structure1Map.entrySet().stream().allMatch(e -> Objects.equals(e.getValue(), structure2Map.get(e.getKey())));
            return validSize && validEntries;
        }

        @Override
        protected StructureHolder<TypedValue> convertStructure1toHolder(DecisionInput value) {
            return new StructureHolder<TypedValue>(value.getValue().getKind(), value.getName(), value.getValue().getType(), value.getValue());
        }

        @Override
        protected StructureHolder<CounterfactualSearchDomainValue> convertStructure2toHolder(CounterfactualSearchDomain value) {
            return new StructureHolder<CounterfactualSearchDomainValue>(value.getValue().getKind(), value.getName(), value.getValue().getType(), value.getValue());
        }

        @Override
        protected Collection<StructureHolder<TypedValue>> getChildrenOfStructure1(TypedValue value) {
            if (value.getKind() != BaseTypedValue.Kind.STRUCTURE) {
                return Collections.emptyList();
            }
            return ((StructureValue)value.toStructure()).getValue().entrySet().stream().map(e -> new StructureHolder<TypedValue>(((TypedValue)e.getValue()).getKind(), (String)e.getKey(), ((TypedValue)e.getValue()).getType(), (TypedValue)e.getValue())).collect(Collectors.toList());
        }

        @Override
        protected Collection<StructureHolder<CounterfactualSearchDomainValue>> getChildrenOfStructure2(CounterfactualSearchDomainValue value) {
            if (value.getKind() != BaseTypedValue.Kind.STRUCTURE) {
                return Collections.emptyList();
            }
            return ((CounterfactualSearchDomainStructureValue)value.toStructure()).getValue().entrySet().stream().map(e -> new StructureHolder<CounterfactualSearchDomainValue>(((CounterfactualSearchDomainValue)e.getValue()).getKind(), (String)e.getKey(), ((CounterfactualSearchDomainValue)e.getValue()).getType(), (CounterfactualSearchDomainValue)e.getValue())).collect(Collectors.toList());
        }
    }

    private static abstract class BaseCheck<C, CV, D, DV>
    implements Check<C, D> {
        private BaseCheck() {
        }

        @Override
        public boolean check(Collection<C> structure1, Collection<D> structure2) {
            Collection<StructureHolder<CV>> normalisedStructure1 = this.normaliseStructure1(structure1);
            Collection<StructureHolder<DV>> normalisedStructure2 = this.normaliseStructure2(structure2);
            return this.doCheck(normalisedStructure1, normalisedStructure2);
        }

        protected boolean doCheck(Collection<StructureHolder<CV>> normalisedStructure1, Collection<StructureHolder<DV>> normalisedStructure2) {
            Map<String, StructureHolder<DV>> structure2Map;
            if (Objects.isNull(normalisedStructure1) && Objects.isNull(normalisedStructure2)) {
                return true;
            }
            if (Objects.isNull(normalisedStructure1)) {
                return false;
            }
            if (Objects.isNull(normalisedStructure2)) {
                return false;
            }
            if (normalisedStructure1.isEmpty() && normalisedStructure2.isEmpty()) {
                return true;
            }
            Map<String, StructureHolder<CV>> structure1Map = normalisedStructure1.stream().collect(Collectors.toMap(ih -> ih.name, ih -> ih));
            if (!this.checkMembership(structure1Map, structure2Map = normalisedStructure2.stream().collect(Collectors.toMap(ih -> ih.name, ih -> ih)))) {
                return false;
            }
            Collection structure1ChildStructures = structure1Map.values().stream().map(ih -> this.getChildrenOfStructure1(ih.original)).flatMap(Collection::stream).collect(Collectors.toList());
            Collection structure2ChildStructures = structure2Map.values().stream().map(ih -> this.getChildrenOfStructure2(ih.original)).flatMap(Collection::stream).collect(Collectors.toList());
            return this.doCheck(structure1ChildStructures, structure2ChildStructures);
        }

        protected Collection<StructureHolder<CV>> normaliseStructure1(Collection<C> structure1) {
            if (Objects.isNull(structure1)) {
                return null;
            }
            return structure1.stream().map(this::convertStructure1toHolder).collect(Collectors.toList());
        }

        protected Collection<StructureHolder<DV>> normaliseStructure2(Collection<D> structure2) {
            if (Objects.isNull(structure2)) {
                return null;
            }
            return structure2.stream().map(this::convertStructure2toHolder).collect(Collectors.toList());
        }

        protected abstract StructureHolder<CV> convertStructure1toHolder(C var1);

        protected abstract StructureHolder<DV> convertStructure2toHolder(D var1);

        protected abstract Collection<StructureHolder<CV>> getChildrenOfStructure1(CV var1);

        protected abstract Collection<StructureHolder<DV>> getChildrenOfStructure2(DV var1);

        protected abstract boolean checkMembership(Map<String, StructureHolder<CV>> var1, Map<String, StructureHolder<DV>> var2);
    }

    private static interface Check<C, D> {
        public boolean check(Collection<C> var1, Collection<D> var2);
    }
}

