/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.subscription;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.CancellableSubscriber;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Subscription;

public class Subscribers {
    public static final Consumer<? super Throwable> NO_ON_FAILURE = failure -> new Exception("Missing onFailure/onError handler in the subscriber", (Throwable)failure).printStackTrace();

    public static <T> CancellableSubscriber<T> from(Consumer<? super T> onItem, Consumer<? super Throwable> onFailure, Runnable onCompletion, Consumer<? super Subscription> onSubscription) {
        return new CallbackBasedSubscriber<T>(onItem, onFailure, onCompletion, onSubscription);
    }

    public static class CallbackBasedSubscriber<T>
    implements CancellableSubscriber<T>,
    Subscription {
        private volatile Subscription subscription;
        private static final AtomicReferenceFieldUpdater<CallbackBasedSubscriber, Subscription> SUBSCRIPTION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CallbackBasedSubscriber.class, Subscription.class, "subscription");
        private final Consumer<? super T> onItem;
        private final Consumer<? super Throwable> onFailure;
        private final Runnable onCompletion;
        private final Consumer<? super Subscription> onSubscription;

        public CallbackBasedSubscriber(Consumer<? super T> onItem, Consumer<? super Throwable> onFailure, Runnable onCompletion, Consumer<? super Subscription> onSubscription) {
            this.onItem = ParameterValidation.nonNull(onItem, "onItem");
            this.onFailure = onFailure;
            this.onCompletion = onCompletion;
            this.onSubscription = ParameterValidation.nonNull(onSubscription, "onSubscription");
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SUBSCRIPTION_UPDATER.compareAndSet(this, null, s)) {
                try {
                    this.onSubscription.accept(this);
                }
                catch (Throwable ex) {
                    s.cancel();
                    Infrastructure.handleDroppedException(ex);
                }
            } else {
                s.cancel();
            }
        }

        @Override
        public void onItem(T item) {
            Objects.requireNonNull(item);
            if (SUBSCRIPTION_UPDATER.get(this) != Subscriptions.CANCELLED) {
                try {
                    this.onItem.accept(item);
                }
                catch (Throwable e) {
                    SUBSCRIPTION_UPDATER.getAndSet(this, Subscriptions.CANCELLED).cancel();
                    Infrastructure.handleDroppedException(e);
                }
            }
        }

        @Override
        public void onFailure(Throwable t) {
            Objects.requireNonNull(t);
            if (SUBSCRIPTION_UPDATER.getAndSet(this, Subscriptions.CANCELLED) != Subscriptions.CANCELLED) {
                if (this.onFailure != null) {
                    try {
                        this.onFailure.accept(t);
                    }
                    catch (Throwable e) {
                        Infrastructure.handleDroppedException(new CompositeException(t, e));
                    }
                } else {
                    Infrastructure.handleDroppedException(t);
                }
            } else {
                Infrastructure.handleDroppedException(t);
            }
        }

        @Override
        public void onCompletion() {
            if (SUBSCRIPTION_UPDATER.getAndSet(this, Subscriptions.CANCELLED) != Subscriptions.CANCELLED && this.onCompletion != null) {
                this.onCompletion.run();
            }
        }

        @Override
        public void request(long n) {
            SUBSCRIPTION_UPDATER.get(this).request(n);
        }

        @Override
        public void cancel() {
            Subscription prev = SUBSCRIPTION_UPDATER.getAndSet(this, Subscriptions.CANCELLED);
            if (prev != null && prev != Subscriptions.CANCELLED) {
                prev.cancel();
            }
        }
    }
}

