/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.services;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.kie.api.definition.KiePackage;
import org.kie.api.internal.io.ResourceTypePackage;
import org.kie.api.internal.weaver.KieWeaverService;
import org.kie.api.internal.weaver.KieWeavers;
import org.kie.api.io.ResourceType;

public class KieWeaversImpl
implements KieWeavers,
Consumer<KieWeaverService> {
    private Map<ResourceType, KieWeaverService> weavers = new HashMap<ResourceType, KieWeaverService>();

    public Map<ResourceType, KieWeaverService> getWeavers() {
        return this.weavers;
    }

    @Override
    public void accept(KieWeaverService weaver) {
        this.weavers.put(weaver.getResourceType(), weaver);
    }

    @Override
    public void weave(KiePackage newPkg, ResourceTypePackage rtkKpg) {
        KieWeaverService svc = this.weavers.get(rtkKpg.getResourceType());
        if (svc != null) {
            svc.weave(newPkg, rtkKpg);
        }
    }

    @Override
    public void merge(KiePackage pkg, ResourceTypePackage rtkKpg) {
        KieWeaverService svc = this.weavers.get(rtkKpg.getResourceType());
        if (svc != null) {
            svc.merge(pkg, rtkKpg);
        }
    }
}

