/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.KiePMMLTargetValue;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;

public class KiePMMLTarget
extends AbstractKiePMMLComponent {
    private static final long serialVersionUID = -6336733489238275499L;
    private List<KiePMMLTargetValue> targetValues = null;
    private OP_TYPE opType;
    private String field;
    private CAST_INTEGER castInteger;
    private Double min = null;
    private Double max = null;
    private double rescaleConstant = 0.0;
    private double rescaleFactor = 1.0;

    private KiePMMLTarget(String name, List<KiePMMLExtension> extensions) {
        super(name, extensions);
    }

    public static Builder builder(String name, List<KiePMMLExtension> extensions) {
        return new Builder(name, extensions);
    }

    public Object modifyPrediction(Object prediction) {
        if (!(prediction instanceof Number)) {
            return prediction;
        }
        double predictionDouble = (Double)prediction;
        Number toReturn = this.applyMin(predictionDouble);
        toReturn = this.applyMax((double)toReturn);
        toReturn = this.applyRescaleFactor((double)toReturn);
        toReturn = this.applyRescaleConstant((double)toReturn);
        toReturn = this.applyCastInteger((double)toReturn);
        return toReturn;
    }

    Double applyMin(double predictionDouble) {
        return this.min != null ? Math.max(this.min, predictionDouble) : predictionDouble;
    }

    Double applyMax(double predictionDouble) {
        return this.max != null ? Math.min(this.max, predictionDouble) : predictionDouble;
    }

    Double applyRescaleFactor(double predictionDouble) {
        return predictionDouble * this.rescaleFactor;
    }

    Double applyRescaleConstant(double predictionDouble) {
        return predictionDouble + this.rescaleConstant;
    }

    Number applyCastInteger(double predictionDouble) {
        return this.castInteger != null ? (double)this.castInteger.getScaledValue(predictionDouble).intValue() : predictionDouble;
    }

    public String getField() {
        return this.field;
    }

    public List<KiePMMLTargetValue> getTargetValues() {
        return this.targetValues;
    }

    public OP_TYPE getOpType() {
        return this.opType;
    }

    public CAST_INTEGER getCastInteger() {
        return this.castInteger;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public double getRescaleConstant() {
        return this.rescaleConstant;
    }

    public double getRescaleFactor() {
        return this.rescaleFactor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KiePMMLTarget that = (KiePMMLTarget)o;
        return Double.compare(that.rescaleConstant, this.rescaleConstant) == 0 && Double.compare(that.rescaleFactor, this.rescaleFactor) == 0 && Objects.equals(this.targetValues, that.targetValues) && this.opType == that.opType && Objects.equals(this.field, that.field) && this.castInteger == that.castInteger && Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.targetValues, this.opType, this.field, this.castInteger, this.min, this.max, this.rescaleConstant, this.rescaleFactor});
    }

    public String toString() {
        return new StringJoiner(", ", KiePMMLTarget.class.getSimpleName() + "[", "]").add("targetValues=" + this.targetValues).add("opType=" + (Object)((Object)this.opType)).add("field='" + this.field + "'").add("castInteger=" + (Object)((Object)this.castInteger)).add("min=" + this.min).add("max=" + this.max).add("rescaleConstant=" + this.rescaleConstant).add("rescaleFactor=" + this.rescaleFactor).add("name='" + this.name + "'").add("extensions=" + this.extensions).add("id='" + this.id + "'").add("parentId='" + this.parentId + "'").toString();
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLTarget> {
        private Builder(String name, List<KiePMMLExtension> extensions) {
            super("Target-", () -> new KiePMMLTarget(name, extensions));
        }

        public Builder withTargetValues(List<KiePMMLTargetValue> targetValues) {
            ((KiePMMLTarget)this.toBuild).targetValues = Collections.unmodifiableList(targetValues);
            return this;
        }

        public Builder withOpType(OP_TYPE opType) {
            ((KiePMMLTarget)this.toBuild).opType = opType;
            return this;
        }

        public Builder withField(String field) {
            ((KiePMMLTarget)this.toBuild).field = field;
            return this;
        }

        public Builder withCastInteger(CAST_INTEGER castInteger) {
            ((KiePMMLTarget)this.toBuild).castInteger = castInteger;
            return this;
        }

        public Builder withMin(Double min) {
            ((KiePMMLTarget)this.toBuild).min = min;
            return this;
        }

        public Builder withMax(Double max) {
            ((KiePMMLTarget)this.toBuild).max = max;
            return this;
        }

        public Builder withRescaleConstant(Double rescaleConstant) {
            if (rescaleConstant != null) {
                ((KiePMMLTarget)this.toBuild).rescaleConstant = rescaleConstant;
            }
            return this;
        }

        public Builder withRescaleFactor(Double rescaleFactor) {
            if (rescaleFactor != null) {
                ((KiePMMLTarget)this.toBuild).rescaleFactor = rescaleFactor;
            }
            return this;
        }
    }
}

