/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.impl.CloudEventUtils;
import io.cloudevents.jackson.JsonFormat;
import io.cloudevents.rw.CloudEventAttributesWriter;
import io.cloudevents.rw.CloudEventExtensionsWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class CloudEventSerializer
extends StdSerializer<CloudEvent> {
    private final boolean forceDataBase64Serialization;
    private final boolean forceStringSerialization;

    protected CloudEventSerializer(boolean forceDataBase64Serialization, boolean forceStringSerialization) {
        super(CloudEvent.class);
        this.forceDataBase64Serialization = forceDataBase64Serialization;
        this.forceStringSerialization = forceStringSerialization;
    }

    @Override
    public void serialize(CloudEvent value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("specversion", value.getSpecVersion().toString());
        try {
            CloudEventReader visitable = CloudEventUtils.toVisitable(value);
            FieldsSerializer serializer = new FieldsSerializer(gen, provider);
            visitable.readAttributes(serializer);
            visitable.readExtensions(serializer);
        }
        catch (RuntimeException e) {
            throw (IOException)e.getCause();
        }
        byte[] data = value.getData();
        String contentType = value.getDataContentType();
        if (data != null) {
            if (this.shouldSerializeBase64(contentType)) {
                switch (value.getSpecVersion()) {
                    case V03: {
                        gen.writeStringField("datacontentencoding", "base64");
                        gen.writeFieldName("data");
                        gen.writeBinary(data);
                        break;
                    }
                    case V1: {
                        gen.writeFieldName("data_base64");
                        gen.writeBinary(data);
                    }
                }
            } else if (JsonFormat.dataIsJsonContentType(contentType)) {
                char[] dataAsString = new String(data, StandardCharsets.UTF_8).toCharArray();
                gen.writeFieldName("data");
                gen.writeRawValue(dataAsString, 0, dataAsString.length);
            } else {
                gen.writeFieldName("data");
                gen.writeUTF8String(data, 0, data.length);
            }
        }
        gen.writeEndObject();
    }

    private boolean shouldSerializeBase64(String contentType) {
        if (JsonFormat.dataIsJsonContentType(contentType)) {
            return this.forceDataBase64Serialization;
        }
        return !this.forceStringSerialization;
    }

    private static class FieldsSerializer
    implements CloudEventAttributesWriter,
    CloudEventExtensionsWriter {
        private final JsonGenerator gen;
        private final SerializerProvider provider;

        public FieldsSerializer(JsonGenerator gen, SerializerProvider provider) {
            this.gen = gen;
            this.provider = provider;
        }

        @Override
        public FieldsSerializer withAttribute(String name, String value) throws CloudEventRWException {
            try {
                this.gen.writeStringField(name, value);
                return this;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public FieldsSerializer withExtension(String name, String value) throws CloudEventRWException {
            try {
                this.gen.writeStringField(name, value);
                return this;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public FieldsSerializer withExtension(String name, Number value) throws CloudEventRWException {
            try {
                this.gen.writeFieldName(name);
                this.provider.findValueSerializer(value.getClass()).serialize(value, this.gen, this.provider);
                return this;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public FieldsSerializer withExtension(String name, Boolean value) throws CloudEventRWException {
            try {
                this.gen.writeBooleanField(name, value);
                return this;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

