/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.models;

import io.smallrye.openapi.api.models.ExtensibleImpl;
import io.smallrye.openapi.api.models.ModelImpl;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.servers.Server;

public class PathItemImpl
extends ExtensibleImpl<PathItem>
implements PathItem,
ModelImpl {
    private String ref;
    private String summary;
    private String description;
    private Operation get;
    private Operation put;
    private Operation post;
    private Operation delete;
    private Operation options;
    private Operation head;
    private Operation patch;
    private Operation trace;
    private List<Parameter> parameters;
    private List<Server> servers;

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    public void setRef(String ref) {
        this.ref = ref;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public PathItem summary(String summary) {
        this.summary = summary;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Operation getGET() {
        return this.get;
    }

    @Override
    public void setGET(Operation get) {
        this.get = get;
    }

    @Override
    public Operation getPUT() {
        return this.put;
    }

    @Override
    public void setPUT(Operation put) {
        this.put = put;
    }

    @Override
    public Operation getPOST() {
        return this.post;
    }

    @Override
    public void setPOST(Operation post) {
        this.post = post;
    }

    @Override
    public Operation getDELETE() {
        return this.delete;
    }

    @Override
    public void setDELETE(Operation delete) {
        this.delete = delete;
    }

    @Override
    public Operation getOPTIONS() {
        return this.options;
    }

    @Override
    public void setOPTIONS(Operation options) {
        this.options = options;
    }

    @Override
    public Operation getHEAD() {
        return this.head;
    }

    @Override
    public void setHEAD(Operation head) {
        this.head = head;
    }

    @Override
    public Operation getPATCH() {
        return this.patch;
    }

    @Override
    public void setPATCH(Operation patch) {
        this.patch = patch;
    }

    @Override
    public Operation getTRACE() {
        return this.trace;
    }

    @Override
    public void setTRACE(Operation trace) {
        this.trace = trace;
    }

    @Override
    public Map<PathItem.HttpMethod, Operation> getOperations() {
        LinkedHashMap<PathItem.HttpMethod, Operation> ops = new LinkedHashMap<PathItem.HttpMethod, Operation>();
        this.addOperationToMap(PathItem.HttpMethod.GET, this.get, ops);
        this.addOperationToMap(PathItem.HttpMethod.PUT, this.put, ops);
        this.addOperationToMap(PathItem.HttpMethod.POST, this.post, ops);
        this.addOperationToMap(PathItem.HttpMethod.DELETE, this.delete, ops);
        this.addOperationToMap(PathItem.HttpMethod.OPTIONS, this.options, ops);
        this.addOperationToMap(PathItem.HttpMethod.HEAD, this.head, ops);
        this.addOperationToMap(PathItem.HttpMethod.PATCH, this.patch, ops);
        this.addOperationToMap(PathItem.HttpMethod.TRACE, this.trace, ops);
        return ops;
    }

    public void setOperation(PathItem.HttpMethod httpMethod, Operation operation) {
        switch (httpMethod) {
            case GET: {
                this.get = operation;
                break;
            }
            case POST: {
                this.post = operation;
                break;
            }
            case PUT: {
                this.put = operation;
                break;
            }
            case DELETE: {
                this.delete = operation;
                break;
            }
            case PATCH: {
                this.patch = operation;
                break;
            }
            case OPTIONS: {
                this.options = operation;
                break;
            }
            case HEAD: {
                this.head = operation;
                break;
            }
            case TRACE: {
                this.trace = operation;
            }
        }
    }

    @Override
    public List<Server> getServers() {
        return ModelUtil.unmodifiableList(this.servers);
    }

    @Override
    public void setServers(List<Server> servers) {
        this.servers = ModelUtil.replace(servers, ArrayList::new);
    }

    @Override
    public PathItem addServer(Server server) {
        this.servers = ModelUtil.add(server, this.servers, ArrayList::new);
        return this;
    }

    @Override
    public void removeServer(Server server) {
        ModelUtil.remove(this.servers, server);
    }

    @Override
    public List<Parameter> getParameters() {
        return ModelUtil.unmodifiableList(this.parameters);
    }

    @Override
    public void setParameters(List<Parameter> parameters) {
        this.parameters = ModelUtil.replace(parameters, ArrayList::new);
    }

    @Override
    public PathItem addParameter(Parameter parameter) {
        this.parameters = ModelUtil.add(parameter, this.parameters, ArrayList::new);
        return this;
    }

    @Override
    public void removeParameter(Parameter parameter) {
        ModelUtil.remove(this.parameters, parameter);
    }

    private void addOperationToMap(PathItem.HttpMethod method, Operation operation, Map<PathItem.HttpMethod, Operation> operationMap) {
        if (operation != null) {
            operationMap.put(method, operation);
        }
    }
}

