/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SubscriberWrapper<I, T>
implements Processor<T, T> {
    private final Subscriber<I> delegate;
    private final BiFunction<T, Throwable, CompletionStage<Void>> postAck;
    private final AtomicReference<Subscriber<? super T>> subscriber = new AtomicReference();
    private final Function<T, I> mapper;

    public SubscriberWrapper(Subscriber<I> subscriber, Function<T, I> mapper, BiFunction<T, Throwable, CompletionStage<Void>> postAck) {
        this.delegate = Objects.requireNonNull(subscriber);
        this.mapper = Objects.requireNonNull(mapper);
        this.postAck = postAck;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (!this.subscriber.compareAndSet(null, s)) {
            s.onSubscribe(new Subscription(){

                @Override
                public void request(long n) {
                }

                @Override
                public void cancel() {
                }
            });
            s.onError(ProviderExceptions.ex.illegalStateForNotSupported("Broadcast"));
        }
    }

    @Override
    public void onSubscribe(final Subscription s) {
        this.subscriber.get().onSubscribe(new Subscription(){

            @Override
            public void request(long n) {
            }

            @Override
            public void cancel() {
                s.cancel();
            }
        });
        this.delegate.onSubscribe(s);
    }

    @Override
    public void onNext(T item) {
        try {
            this.delegate.onNext(this.mapper.apply(item));
            if (this.postAck != null) {
                this.postAck.apply(item, null).thenAccept(x -> this.subscriber.get().onNext(item));
            } else {
                this.subscriber.get().onNext(item);
            }
        }
        catch (Exception e) {
            if (this.postAck != null) {
                this.postAck.apply(item, e).thenAccept(x -> this.subscriber.get().onNext(item));
            }
            this.subscriber.get().onError(e);
        }
    }

    @Override
    public void onError(Throwable error) {
        this.delegate.onError(error);
    }

    @Override
    public void onComplete() {
        this.delegate.onComplete();
    }
}

