/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.generators.mvel;

import io.vertx.codegen.Case;
import io.vertx.codegen.Generator;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.Model;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.generators.mvel.Template;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.TypeNameTranslator;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import org.mvel2.MVEL;

public class MvelCodeGenerator
extends Generator<Model> {
    public String filename;
    public String templateFilename;
    private Template template;
    private Serializable filenameExpr;

    @Override
    public void load(ProcessingEnvironment processingEnv) {
        super.load(processingEnv);
        Template template = new Template(this.templateFilename);
        template.setOptions(processingEnv.getOptions());
        this.template = template;
        this.filenameExpr = MVEL.compileExpression(this.filename);
    }

    @Override
    public Collection<Class<? extends Annotation>> annotations() {
        return Arrays.asList(VertxGen.class, DataObject.class, ModuleGen.class);
    }

    @Override
    public String filename(Model model) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("helper", new Helper());
        vars.put("options", this.env.getOptions());
        vars.put("fileSeparator", File.separator);
        vars.put("fqn", model.getFqn());
        vars.put("module", model.getModule());
        vars.put("model", model);
        vars.putAll(model.getVars());
        vars.putAll(ClassKind.vars());
        vars.putAll(MethodKind.vars());
        vars.putAll(Case.vars());
        vars.putAll(TypeNameTranslator.vars(this.name));
        return (String)MVEL.executeExpression((Object)this.filenameExpr, vars);
    }

    @Override
    public String render(Model model, int index, int size, Map<String, Object> session) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.putAll(TypeNameTranslator.vars(this.name));
        if (this.incremental) {
            vars.put("incrementalIndex", index);
            vars.put("incrementalSize", size);
            vars.put("session", session);
        }
        return this.template.render(model, vars);
    }
}

