/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.redis;

import io.redisearch.Query;
import java.util.ArrayList;
import java.util.List;
import org.kie.kogito.persistence.api.query.AttributeFilter;

public class RedisQueryFactory {
    static String buildQueryBody(String indexName, List<AttributeFilter<?>> filters) {
        ArrayList<String> components = new ArrayList<String>();
        components.add(String.format("@%s:%s", "indexName", indexName));
        for (AttributeFilter<?> attributeFilter : filters) {
            switch (attributeFilter.getCondition()) {
                case EQUAL: {
                    components.add(String.format("@%s:%s", attributeFilter.getAttribute(), attributeFilter.getValue()));
                    break;
                }
                case LIKE: {
                    if ("".equals(attributeFilter.getValue()) || "*".equals(attributeFilter.getValue())) break;
                    components.add(String.format("@%s:%s", attributeFilter.getAttribute(), attributeFilter.getValue()));
                }
            }
        }
        return String.join((CharSequence)" ", components);
    }

    static void addFilters(Query query, List<AttributeFilter<?>> filters) {
        block8: for (AttributeFilter<?> attributeFilter : filters) {
            switch (attributeFilter.getCondition()) {
                case EQUAL: 
                case LIKE: {
                    continue block8;
                }
                case GT: {
                    query.addFilter(new Query.NumericFilter(attributeFilter.getAttribute(), RedisQueryFactory.convertNumeric(attributeFilter.getValue()), true, Double.POSITIVE_INFINITY, false));
                    continue block8;
                }
                case GTE: {
                    query.addFilter(new Query.NumericFilter(attributeFilter.getAttribute(), RedisQueryFactory.convertNumeric(attributeFilter.getValue()), false, Double.POSITIVE_INFINITY, false));
                    continue block8;
                }
                case LT: {
                    query.addFilter(new Query.NumericFilter(attributeFilter.getAttribute(), Double.NEGATIVE_INFINITY, false, RedisQueryFactory.convertNumeric(attributeFilter.getValue()), true));
                    continue block8;
                }
                case LTE: {
                    query.addFilter(new Query.NumericFilter(attributeFilter.getAttribute(), Double.NEGATIVE_INFINITY, false, RedisQueryFactory.convertNumeric(attributeFilter.getValue()), false));
                    continue block8;
                }
                case BETWEEN: {
                    List value = (List)attributeFilter.getValue();
                    query.addFilter(new Query.NumericFilter(attributeFilter.getAttribute(), RedisQueryFactory.convertNumeric(value.get(0)), false, RedisQueryFactory.convertNumeric(value.get(1)), false));
                    continue block8;
                }
            }
            throw new UnsupportedOperationException("Redis does not support query filter: " + attributeFilter.getCondition());
        }
    }

    private static Double convertNumeric(Object obj) {
        if (obj instanceof Long) {
            return ((Long)obj).doubleValue();
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).doubleValue();
        }
        return (Double)obj;
    }
}

